/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import com.nedap.archie.rm.datatypes.CodePhrase;
import java.util.Arrays;
import java.util.Map;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CArchetypeConstraintValidate;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.ARCHETYPECONSTRAINT;
import org.openehr.schemas.v1.CCODEPHRASE;

public class CCodePhrase
extends CConstraint
implements I_CArchetypeConstraintValidate {
    CCodePhrase(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object aValue, ARCHETYPECONSTRAINT archetypeconstraint) throws IllegalArgumentException {
        String terminologyid;
        if (!(aValue instanceof CodePhrase)) {
            throw new IllegalStateException("INTERNAL: argument is not a CodePhrase");
        }
        CodePhrase codePhrase = (CodePhrase)aValue;
        CCODEPHRASE ccodephrase = (CCODEPHRASE)archetypeconstraint;
        if (ccodephrase.isSetTerminologyId() && (terminologyid = ccodephrase.getTerminologyId().getValue()) != null) {
            if (!codePhrase.getTerminologyId().getValue().equals(terminologyid)) {
                ValidationException.raise(path, "CodePhrase terminology does not match, expected:" + terminologyid + ", found:" + codePhrase.getTerminologyId().getValue(), "CODE_PHRASE_02");
            }
            if ((terminologyid.equals("openehr") || terminologyid.equals("local")) && ccodephrase.sizeOfCodeListArray() > 0 && !Arrays.asList(ccodephrase.getCodeListArray()).contains(codePhrase.getCodeString())) {
                ValidationException.raise(path, "CodePhrase codeString does not match any option, found:" + codePhrase.getCodeString(), "CODE_PHRASE_03");
            }
        }
    }
}

