/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints.wrappers;

import java.util.Map;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.constraints.wrappers.CConstraint;
import org.ehrbase.validation.constraints.wrappers.I_CTypeValidate;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.openehr.schemas.v1.CBOOLEAN;
import org.openehr.schemas.v1.CPRIMITIVE;

public class CBoolean
extends CConstraint
implements I_CTypeValidate {
    protected CBoolean(Map<String, Map<String, String>> localTerminologyLookup, ExternalTerminologyValidationSupport externalTerminologyValidator) {
        super(localTerminologyLookup, externalTerminologyValidator);
    }

    @Override
    public void validate(String path, Object value, CPRIMITIVE cprimitive) {
        Boolean dvBoolean = (Boolean)value;
        CBOOLEAN cboolean = (CBOOLEAN)cprimitive;
        if (dvBoolean.booleanValue() && !cboolean.getTrueValid()) {
            ValidationException.raise(path, "TRUE value is not allowed", "BOOL01");
        } else if (!dvBoolean.booleanValue() && !cboolean.getFalseValid()) {
            ValidationException.raise(path, "FALSE value is not allowed", "BOOL02");
        }
    }
}

