/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.constraints;

import com.nedap.archie.base.MultiplicityInterval;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ehrbase.validation.constraints.ConstraintOccurrences;

public abstract class ConstraintMapper
implements Serializable {
    protected Map<String, Map<String, String>> localTerminologyLookup;
    protected Map<String, OccurrenceItem> watchList = new HashMap<String, OccurrenceItem>();
    protected Set<String> validNodeList = new HashSet<String>();
    protected Map<String, CardinalityItem> cardinalityList = new HashMap<String, CardinalityItem>();
    protected Map<String, ConstraintOccurrences> occurrencesMap = new HashMap<String, ConstraintOccurrences>();
    Map<String, List<ConstraintItem>> elementConstraintMap = new HashMap<String, List<ConstraintItem>>();

    public Map<String, CardinalityItem> getCardinalityList() {
        return this.cardinalityList;
    }

    public List<ConstraintItem> getConstraintItem(String key) {
        return this.elementConstraintMap.get(key);
    }

    public Map<String, Map<String, String>> getLocalTerminologyLookup() {
        return this.localTerminologyLookup;
    }

    public boolean isValidNode(String path) {
        return this.validNodeList.contains(path);
    }

    public void updateWatchList(String path) {
        this.watchList.remove(path);
    }

    Iterator<Map.Entry<String, List<ConstraintItem>>> getElementConstraintIterator() {
        return this.elementConstraintMap.entrySet().iterator();
    }

    public Map<String, ConstraintOccurrences> getOccurrencesMap() {
        return this.occurrencesMap;
    }

    public abstract class ConstraintItem
    implements Serializable {
        private String path;

        ConstraintItem(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public class CardinalityItem
    implements Serializable {
        private ConstraintOccurrences existence;
        private ConstraintOccurrences cardinality;

        CardinalityItem(ConstraintOccurrences existence, ConstraintOccurrences cardinality) {
            this.existence = existence;
            this.cardinality = cardinality;
        }

        public ConstraintOccurrences getExistence() {
            return this.existence;
        }

        public ConstraintOccurrences getCardinality() {
            return this.cardinality;
        }
    }

    public class OccurrenceItem
    implements Serializable {
        private ConstraintOccurrences constraintOccurrences;
        private MultiplicityInterval existence;

        OccurrenceItem(ConstraintOccurrences constraintOccurrences, MultiplicityInterval existence) {
            this.constraintOccurrences = constraintOccurrences;
            this.existence = existence;
        }

        public ConstraintOccurrences getConstraintOccurrences() {
            return this.constraintOccurrences;
        }

        public MultiplicityInterval getExistence() {
            return this.existence;
        }
    }
}

