/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.webtemplate;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datavalues.DvCodedText;
import java.util.List;
import java.util.Map;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.serialisation.walker.FromCompositionWalker;
import org.ehrbase.util.reflection.ReflectionHelper;
import org.ehrbase.validation.ConstraintViolation;
import org.ehrbase.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.validation.webtemplate.ConstraintValidator;
import org.ehrbase.validation.webtemplate.DefaultValidator;
import org.ehrbase.validation.webtemplate.DvCodedTextValidator;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationWalker
extends FromCompositionWalker<List<ConstraintViolation>> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Map<Class<? extends RMObject>, ConstraintValidator> VALIDATORS = ReflectionHelper.buildMap(ConstraintValidator.class);
    private static final DefaultValidator DEFAULT_VALIDATOR = new DefaultValidator();

    public ValidationWalker(ExternalTerminologyValidation externalTerminologyValidation) {
        if (externalTerminologyValidation != null) {
            VALIDATORS.put(DvCodedText.class, new DvCodedTextValidator(externalTerminologyValidation));
        }
    }

    protected void preHandle(Context<List<ConstraintViolation>> context) {
        WebTemplateNode node = (WebTemplateNode)context.getNodeDeque().element();
        RMObject rmObject = (RMObject)context.getRmObjectDeque().element();
        List result = (List)context.getObjectDeque().element();
        this.logger.trace("PreHandle: {}, rmObject={}", (Object)node, (Object)rmObject);
        ConstraintValidator<RMObject> validator = this.getValidator(rmObject);
        result.addAll(validator.validate(rmObject, node));
    }

    protected List<ConstraintViolation> extract(Context<List<ConstraintViolation>> context, WebTemplateNode child, boolean isChoice, Integer i) {
        return (List)context.getObjectDeque().peek();
    }

    protected void postHandle(Context<List<ConstraintViolation>> context) {
    }

    private <T extends RMObject> ConstraintValidator<T> getValidator(RMObject object) {
        return VALIDATORS.getOrDefault(object.getClass(), DEFAULT_VALIDATOR);
    }
}

