/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.webtemplate;

import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.quantity.DvOrdinal;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.ehrbase.validation.ConstraintViolation;
import org.ehrbase.validation.webtemplate.ConstraintValidator;
import org.ehrbase.validation.webtemplate.DvCodedTextValidator;
import org.ehrbase.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public class DvOrdinalValidator
implements ConstraintValidator<DvOrdinal> {
    public Class<DvOrdinal> getAssociatedClass() {
        return DvOrdinal.class;
    }

    @Override
    public List<ConstraintViolation> validate(DvOrdinal dvOrdinal, WebTemplateNode node) {
        if (!WebTemplateValidationUtils.hasInputs(node)) {
            return Collections.emptyList();
        }
        DvCodedText symbol = dvOrdinal.getSymbol();
        List<ConstraintViolation> result = new DvCodedTextValidator().validate(symbol, node);
        if (result.isEmpty()) {
            WebTemplateInput input = WebTemplateValidationUtils.getInputWithType(node, "CODED_TEXT");
            input.getList().stream().filter(inputValue -> Objects.equals(inputValue.getValue(), symbol.getDefiningCode().getCodeString())).findFirst().ifPresent(inputValue -> {
                if (dvOrdinal.getValue().longValue() != inputValue.getOrdinal().longValue()) {
                    result.add(new ConstraintViolation(node.getAqlPath(), MessageFormat.format("The value {0} must be {1}", dvOrdinal.getValue(), inputValue.getOrdinal().longValue())));
                }
            });
        }
        return result;
    }
}

