/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation.webtemplate;

import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessageIds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.ehrbase.validation.ConstraintViolation;
import org.ehrbase.validation.webtemplate.ConstraintValidator;
import org.ehrbase.validation.webtemplate.WebTemplateValidationUtils;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public class DefaultValidator
implements ConstraintValidator<RMObject> {
    public Class<RMObject> getAssociatedClass() {
        return RMObject.class;
    }

    @Override
    public List<ConstraintViolation> validate(RMObject object, WebTemplateNode node) {
        if (node == null || !(object instanceof Locatable)) {
            return Collections.emptyList();
        }
        return this.validate((Locatable)object, node);
    }

    @Override
    private List<ConstraintViolation> validate(Locatable locatable, WebTemplateNode node) {
        ArrayList<ConstraintViolation> result = new ArrayList<ConstraintViolation>();
        node.getChildren().forEach(childNode -> {
            int count = 0;
            for (Object item : locatable.itemsAtPath(node.buildRelativePath(childNode, false).toString())) {
                if (item instanceof Locatable) {
                    if (node.isRelativePathNameDependent(childNode) && !Objects.equals(((Locatable)item).getNameAsString(), childNode.getName())) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
            MultiplicityInterval interval = this.getMultiplicityInterval((WebTemplateNode)childNode, node);
            if (!interval.has((Object)count)) {
                String message = RMObjectValidationMessageIds.rm_OCCURRENCE_MISMATCH.getMessage(new Object[]{count, interval.toString()});
                result.add(new ConstraintViolation(childNode.getAqlPath(), message));
            }
        });
        return result;
    }

    private MultiplicityInterval getMultiplicityInterval(WebTemplateNode node, WebTemplateNode parentNode) {
        MultiplicityInterval interval = WebTemplateValidationUtils.getMultiplicityInterval(node);
        parentNode.getCardinalities().stream().filter(cardinality -> BooleanUtils.isTrue((Boolean)cardinality.getExcludeFromWebTemplate()) && cardinality.getIds().contains(node.getId(false))).findFirst().ifPresent(cardinality -> {
            interval.setLower((Object)cardinality.getMin());
            interval.setUpper((Object)cardinality.getMax());
        });
        return interval;
    }
}

