/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.validation;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rmobjectvalidator.RMObjectValidator;
import java.util.List;
import java.util.stream.Collectors;
import org.ehrbase.validation.ConstraintViolation;
import org.ehrbase.validation.terminology.ExternalTerminologyValidation;
import org.ehrbase.validation.webtemplate.ValidationWalker;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.parser.OPTParser;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;

public class CompositionValidator {
    private final RMObjectValidator rmObjectValidator = new RMObjectValidator((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), archetypeId -> null);
    private ExternalTerminologyValidation externalTerminologyValidation;

    public CompositionValidator() {
    }

    public CompositionValidator(ExternalTerminologyValidation externalTerminologyValidation) {
        this.externalTerminologyValidation = externalTerminologyValidation;
    }

    public List<ConstraintViolation> validate(Composition composition, OPERATIONALTEMPLATE template) {
        return this.validate(composition, new OPTParser(template).parse());
    }

    public List<ConstraintViolation> validate(Composition composition, WebTemplate template) {
        List<ConstraintViolation> result = this.rmObjectValidator.validate((Object)composition).stream().map(validationMessage -> new ConstraintViolation(validationMessage.getPath(), validationMessage.getMessage())).collect(Collectors.toList());
        if (result.isEmpty()) {
            new ValidationWalker(this.externalTerminologyValidation).walk((RMObject)composition, result, template.getTree(), template.getTemplateId());
        }
        return result;
    }

    public void setRunInvariantChecks(boolean validateInvariants) {
        this.rmObjectValidator.setRunInvariantChecks(validateInvariants);
    }

    public void setExternalTerminologyValidation(ExternalTerminologyValidation externalTerminologyValidation) {
        this.externalTerminologyValidation = externalTerminologyValidation;
    }
}

