/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.walker;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.composition.IsmTransition;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.ehrbase.serialisation.jsonencoding.CanonicalJson;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.webtemplate.model.FilteredWebTemplate;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public abstract class Walker<T> {
    public static final ArchieRMInfoLookup ARCHIE_RM_INFO_LOOKUP = ArchieRMInfoLookup.getInstance();
    public static final String DV_CODED_TEXT = "DV_CODED_TEXT";

    public void walk(Composition composition, T object, WebTemplate webTemplate, DefaultValues defaultValues) {
        Map filteredNodeMap = null;
        if (webTemplate instanceof FilteredWebTemplate) {
            filteredNodeMap = ((FilteredWebTemplate)webTemplate).filteredNodeMap;
        }
        this.walk((RMObject)composition, object, webTemplate.getTree(), filteredNodeMap, defaultValues);
    }

    public void walk(RMObject composition, T object, WebTemplateNode root) {
        this.walk(composition, object, root, null, null);
    }

    public void walk(RMObject composition, T object, WebTemplateNode root, Map<Pair<String, String>, Deque<WebTemplateNode>> filteredNodeMap, DefaultValues defaultValues) {
        Context context = new Context();
        context.getNodeDeque().push(root);
        context.getObjectDeque().push(object);
        context.getRmObjectDeque().push(composition);
        context.setFilteredNodeMap(filteredNodeMap);
        if (defaultValues != null) {
            context.setDefaultValues(defaultValues);
        } else {
            context.setDefaultValues(new DefaultValues());
        }
        this.handle(context);
    }

    private void handle(Context<T> context) {
        this.preHandle(context);
        WebTemplateNode currentNode = context.getNodeDeque().peek();
        if (this.visitChildren(currentNode)) {
            Map choices = currentNode.getChoicesInChildren();
            ArrayList<WebTemplateNode> children = new ArrayList<WebTemplateNode>(currentNode.getChildren());
            for (WebTemplateNode codeNode : new ArrayList(children)) {
                if (!codeNode.getRmType().equals(DV_CODED_TEXT) || !codeNode.getInputs().stream().map(WebTemplateInput::getSuffix).anyMatch("other"::equals)) continue;
                WebTemplateNode textNode = new WebTemplateNode(codeNode);
                textNode.setRmType("DV_TEXT");
                choices.put(textNode.getAqlPath(), List.of(codeNode, textNode));
                children.add(textNode);
            }
            for (WebTemplateNode textNode : new ArrayList(children)) {
                if (!textNode.getRmType().equals("DV_TEXT")) continue;
                if (!choices.values().stream().flatMap(Collection::stream).noneMatch(arg_0 -> ((WebTemplateNode)textNode).equals(arg_0))) continue;
                WebTemplateNode codeNode = new WebTemplateNode(textNode);
                codeNode.setRmType(DV_CODED_TEXT);
                choices.put(codeNode.getAqlPath(), List.of(textNode, codeNode));
                children.add(codeNode);
            }
            if (children.stream().anyMatch(n -> n.getRmType().equals("EVENT"))) {
                WebTemplateNode event = children.stream().filter(n -> n.getRmType().equals("EVENT")).findAny().orElseThrow();
                EventHelper eventHelper = new EventHelper(event).invoke();
                WebTemplateNode pointEvent = eventHelper.getPointEvent();
                WebTemplateNode intervalEvent = eventHelper.getIntervalEvent();
                choices.put(intervalEvent.getAqlPath(), List.of(intervalEvent, pointEvent));
                children.add(intervalEvent);
                children.add(pointEvent);
                children.remove(event);
            }
            Collection<List> childChoices = children.stream().collect(Collectors.groupingBy(WebTemplateNode::getAqlPath)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).values();
            for (List choces : childChoices) {
                int i;
                if (choces.stream().noneMatch(WebTemplateNode::isMulti)) {
                    for (WebTemplateNode childNode : choces) {
                        ImmutablePair<T, RMObject> pair = this.extractPair(context, currentNode, choices, childNode, null);
                        Object childObject = pair.getLeft();
                        RMObject child = (RMObject)pair.getRight();
                        if (child == null || childObject == null) continue;
                        context.getNodeDeque().push(childNode);
                        context.getObjectDeque().push(childObject);
                        context.getRmObjectDeque().push(child);
                        this.handle(context);
                    }
                    continue;
                }
                int size = this.calculateSize(context, (WebTemplateNode)choces.get(0));
                ArrayList<ImmutableTriple> pairs = new ArrayList<ImmutableTriple>();
                for (i = 0; i < size; ++i) {
                    for (WebTemplateNode childNode : choces) {
                        ImmutablePair<T, RMObject> pair = this.extractPair(context, currentNode, choices, childNode, i);
                        if (pair.getLeft() == null || pair.getRight() == null) continue;
                        pairs.add(new ImmutableTriple(pair.getLeft(), (Object)((RMObject)pair.getRight()), (Object)childNode));
                    }
                }
                for (i = 0; i < Math.min(size, pairs.size()); ++i) {
                    RMObject currentChild = null;
                    Object childObject = null;
                    childObject = ((Triple)pairs.get(i)).getLeft();
                    currentChild = (RMObject)((Triple)pairs.get(i)).getMiddle();
                    WebTemplateNode childNode = (WebTemplateNode)((Triple)pairs.get(i)).getRight();
                    if (currentChild == null || childObject == null) continue;
                    context.getNodeDeque().push(childNode);
                    context.getObjectDeque().push(childObject);
                    context.getRmObjectDeque().push(currentChild);
                    context.getCountMap().put(childNode, i);
                    this.handle(context);
                }
            }
        }
        this.postHandle(context);
        this.insertDefaults(context);
        context.getRmObjectDeque().remove();
        context.getNodeDeque().remove();
        context.getObjectDeque().remove();
    }

    protected abstract ImmutablePair<T, RMObject> extractPair(Context<T> var1, WebTemplateNode var2, Map<String, List<WebTemplateNode>> var3, WebTemplateNode var4, Integer var5);

    protected Object extractRMChild(RMObject currentRM, WebTemplateNode currentNode, WebTemplateNode childNode, boolean isChoice, Integer count, Deque<WebTemplateNode> skippedNodes) {
        Object incrementalRm = currentRM;
        WebTemplateNode incrementalNode = currentNode;
        if (skippedNodes != null) {
            Iterator<WebTemplateNode> it = skippedNodes.descendingIterator();
            while (it.hasNext()) {
                WebTemplateNode node = it.next();
                if (incrementalRm != null) {
                    Object incrementalchild = this.extractRMChild((RMObject)incrementalRm, incrementalNode, node, false, null);
                    incrementalRm = incrementalchild instanceof List ? (((List)incrementalchild).isEmpty() ? null : (RMObject)((List)incrementalchild).get(0)) : (RMObject)incrementalchild;
                }
                incrementalNode = node;
            }
        }
        Object child = incrementalRm != null ? this.extractRMChild((RMObject)incrementalRm, incrementalNode, childNode, isChoice, count) : null;
        return child;
    }

    protected abstract Object extractRMChild(RMObject var1, WebTemplateNode var2, WebTemplateNode var3, boolean var4, Integer var5);

    protected boolean visitChildren(WebTemplateNode node) {
        RMTypeInfo typeInfo = ARCHIE_RM_INFO_LOOKUP.getTypeInfo(node.getRmType());
        return typeInfo != null && (Locatable.class.isAssignableFrom(typeInfo.getJavaClass()) || EventContext.class.isAssignableFrom(typeInfo.getJavaClass()) || DvInterval.class.isAssignableFrom(typeInfo.getJavaClass()) || IsmTransition.class.isAssignableFrom(typeInfo.getJavaClass()));
    }

    protected abstract T extract(Context<T> var1, WebTemplateNode var2, boolean var3, Integer var4);

    protected abstract void preHandle(Context<T> var1);

    protected abstract void postHandle(Context<T> var1);

    protected void insertDefaults(Context<T> context) {
    }

    protected abstract int calculateSize(Context<T> var1, WebTemplateNode var2);

    protected RMObject deepClone(RMObject rmObject) {
        if (rmObject == null) {
            return null;
        }
        CanonicalJson canonicalXML = new CanonicalJson();
        return canonicalXML.unmarshal(canonicalXML.marshal(rmObject), rmObject.getClass());
    }

    protected String buildNamePath(Context<T> context, boolean addCount) {
        StringBuilder sb = new StringBuilder();
        Iterator<WebTemplateNode> iterator = context.getNodeDeque().descendingIterator();
        while (iterator.hasNext()) {
            WebTemplateNode node = iterator.next();
            sb.append(node.getId());
            if (node.getMax() != 1 && context.getCountMap().containsKey(node) && (addCount || context.getCountMap().get(node) != 0)) {
                sb.append(":").append(context.getCountMap().get(node));
            }
            if (!iterator.hasNext()) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public static class EventHelper {
        private WebTemplateNode event;
        private WebTemplateNode pointEvent;
        private WebTemplateNode intervalEvent;

        public EventHelper(WebTemplateNode event) {
            this.event = event;
        }

        public WebTemplateNode getPointEvent() {
            return this.pointEvent;
        }

        public WebTemplateNode getIntervalEvent() {
            return this.intervalEvent;
        }

        public EventHelper invoke() {
            this.pointEvent = new WebTemplateNode(this.event);
            this.intervalEvent = new WebTemplateNode(this.event);
            this.pointEvent.setRmType("POINT_EVENT");
            this.intervalEvent.setRmType("INTERVAL_EVENT");
            WebTemplateNode width = new WebTemplateNode();
            width.setId("width");
            width.setName("width");
            width.setRmType("DV_DURATION");
            width.setMax(1);
            width.setAqlPath(this.event.getAqlPath() + "/width");
            this.intervalEvent.getChildren().add(width);
            WebTemplateNode math = new WebTemplateNode();
            math.setId("math_function");
            math.setName("math_function");
            math.setRmType(Walker.DV_CODED_TEXT);
            math.setMax(1);
            math.setAqlPath(this.event.getAqlPath() + "/math_function");
            this.intervalEvent.getChildren().add(math);
            WebTemplateNode sampleCount = new WebTemplateNode();
            sampleCount.setId("sample_count");
            sampleCount.setName("sample_count");
            sampleCount.setRmType("LONG");
            sampleCount.setMax(1);
            sampleCount.setAqlPath(this.event.getAqlPath() + "/sample_count");
            this.intervalEvent.getChildren().add(sampleCount);
            return this;
        }
    }
}

