/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.walker;

import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.creation.RMObjectCreator;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.IntervalEvent;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datastructures.PointEvent;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.serialisation.walker.ItemExtractor;
import org.ehrbase.serialisation.walker.Walker;
import org.ehrbase.serialisation.walker.defaultvalues.defaultinserter.DefaultValueInserter;
import org.ehrbase.util.reflection.ReflectionHelper;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ToCompositionWalker<T>
extends Walker<T> {
    private static final RMObjectCreator RM_OBJECT_CREATOR = new RMObjectCreator((ModelInfoLookup)ARCHIE_RM_INFO_LOOKUP);
    private static final Map<Class<?>, DefaultValueInserter> DEFAULT_VALUE_INSERTER_MAP = ReflectionHelper.buildMap(DefaultValueInserter.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, List<RMObject>> cloneMap = new HashMap<String, List<RMObject>>();

    @Override
    protected Object extractRMChild(RMObject currentRM, WebTemplateNode currentNode, WebTemplateNode childNode, boolean isChoice, Integer count) {
        ItemExtractor itemExtractor = new ItemExtractor(currentRM, currentNode, childNode, isChoice && !List.of("POINT_EVENT", "INTERVAL_EVENT").contains(childNode.getRmType())).invoke();
        Object child = itemExtractor.getChild();
        Object parent = itemExtractor.getParent();
        String attributeName = StringUtils.substringBefore((String)StringUtils.removeStart((String)itemExtractor.getRelativeAql().format(false), (String)(itemExtractor.getParentAql().format(false) + "/")), (String)"[").replace("/", "");
        if (count != null && child instanceof List) {
            RMObject deepClone;
            List<RMObject> childList;
            if (count == 0) {
                childList = (List<RMObject>)child;
                this.cloneMap.put(childNode.getAqlPath(), childList);
                childList.forEach(c -> this.removeProto(c, parent, attributeName));
            } else {
                childList = this.cloneMap.get(childNode.getAqlPath());
            }
            RMObject proto = childList.get(0);
            RMObject currentChild = deepClone = this.deepClone(proto);
            RM_OBJECT_CREATOR.addElementToListOrSetSingleValues(parent, attributeName, (Object)deepClone);
            child = currentChild;
        }
        String rmclass = childNode.getRmType();
        if (child == null || child.getClass().equals(PointEvent.class) && childNode.getRmType().equals("INTERVAL_EVENT") || child.getClass().equals(IntervalEvent.class) && childNode.getRmType().equals("POINT_EVENT")) {
            Object newChild;
            CComplexObject elementConstraint = new CComplexObject();
            elementConstraint.setRmTypeName(rmclass);
            try {
                newChild = rmclass.equals("UID_BASED_ID") ? new HierObjectId() : RM_OBJECT_CREATOR.create((CObject)elementConstraint);
                if (Event.class.isAssignableFrom(newChild.getClass())) {
                    Event newEvent = (Event)newChild;
                    Event oldEvent = (Event)child;
                    newEvent.setTime(new DvDateTime());
                    if (oldEvent != null) {
                        newEvent.setState((ItemStructure)this.deepClone((RMObject)oldEvent.getState()));
                        newEvent.setData((ItemStructure)this.deepClone((RMObject)oldEvent.getData()));
                        newEvent.setArchetypeDetails(oldEvent.getArchetypeDetails());
                        newEvent.setArchetypeNodeId(oldEvent.getArchetypeNodeId());
                        newEvent.setName(oldEvent.getName());
                        Optional.ofNullable(oldEvent.getTime()).map(DvDateTime::getValue).ifPresent(t -> newEvent.getTime().setValue(t));
                    }
                    if (IntervalEvent.class.isAssignableFrom(newEvent.getClass())) {
                        ((IntervalEvent)newEvent).setWidth(new DvDuration());
                        ((IntervalEvent)newEvent).setMathFunction(new DvCodedText());
                    }
                    this.removeProto(child, parent, attributeName);
                }
                RM_OBJECT_CREATOR.addElementToListOrSetSingleValues(parent, attributeName, Collections.singletonList(newChild));
            }
            catch (IllegalArgumentException e) {
                newChild = null;
            }
            child = newChild;
        }
        return child;
    }

    private void removeProto(Object child, Object parent, String attributeName) {
        RMAttributeInfo attributeInfo = ARCHIE_RM_INFO_LOOKUP.getAttributeInfo(parent.getClass(), attributeName);
        if (attributeInfo.isMultipleValued()) {
            try {
                Object invoke = attributeInfo.getGetMethod().invoke(parent, new Object[0]);
                if (ArrayList.class.isAssignableFrom(invoke.getClass())) {
                    ((List)invoke).remove(((ArrayList)invoke).lastIndexOf(child));
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected ImmutablePair<T, RMObject> extractPair(Context<T> context, WebTemplateNode currentNode, Map<String, List<WebTemplateNode>> choices, WebTemplateNode childNode, Integer i) {
        RMObject currentChild = null;
        Object childObject = null;
        childObject = this.extract(context, childNode, choices.containsKey(childNode.getAqlPath()), i);
        if (childObject != null) {
            currentChild = (RMObject)this.extractRMChild(context.getRmObjectDeque().peek(), currentNode, childNode, choices.containsKey(childNode.getAqlPath()), i, context.getSkippedNodes(childNode));
        }
        return new ImmutablePair(childObject, currentChild);
    }

    @Override
    protected void insertDefaults(Context<T> context) {
        ArrayList<DefaultValueInserter> postprocessor = new ArrayList<DefaultValueInserter>();
        for (Class<?> currentClass = context.getRmObjectDeque().peek().getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (!DEFAULT_VALUE_INSERTER_MAP.containsKey(currentClass)) continue;
            postprocessor.add(DEFAULT_VALUE_INSERTER_MAP.get(currentClass));
        }
        postprocessor.forEach(p -> p.insert(context.getRmObjectDeque().peek(), context.getDefaultValues()));
    }
}

