/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.walker;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.serialisation.walker.RmBoolean;
import org.ehrbase.serialisation.walker.Walker;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.parser.FlatPath;

public class ItemExtractor {
    private RMObject currentRM;
    private WebTemplateNode currentNode;
    private WebTemplateNode childNode;
    private boolean isChoice;
    private String relativeAql;
    private Object child;
    private String parentAql;
    private Object parent;

    public ItemExtractor(RMObject currentRM, WebTemplateNode currentNode, WebTemplateNode childNode, boolean isChoice) {
        this.currentRM = currentRM;
        this.currentNode = currentNode;
        this.childNode = childNode;
        this.isChoice = isChoice;
    }

    public FlatPath getRelativeAql() {
        return new FlatPath(this.relativeAql);
    }

    public Object getChild() {
        return this.child;
    }

    public ItemExtractor invoke() {
        this.relativeAql = StringUtils.removeEnd((String)StringUtils.removeStart((String)this.childNode.getAqlPath(), (String)this.currentNode.getAqlPath()), (String)"/");
        FlatPath childPath = new FlatPath(this.relativeAql);
        this.parentAql = StringUtils.removeEnd((String)childPath.format(false), (String)childPath.format(false).substring(childPath.format(false).lastIndexOf("/")));
        if (StringUtils.isBlank((CharSequence)this.parentAql)) {
            this.parentAql = "/";
        }
        if (this.currentRM instanceof Pathable) {
            try {
                this.child = ((Pathable)this.currentRM).itemsAtPath(childPath.format(false));
                if (this.child == null || ((List)this.child).isEmpty()) {
                    this.child = ((Pathable)this.currentRM).itemAtPath(childPath.format(false));
                }
            }
            catch (RuntimeException e) {
                this.child = null;
            }
            this.parent = ((Pathable)this.currentRM).itemAtPath(this.parentAql);
        } else if (this.currentRM instanceof DvInterval) {
            if (this.relativeAql.contains("upper_included")) {
                this.child = new RmBoolean(((DvInterval)this.currentRM).isUpperIncluded());
            } else if (this.relativeAql.contains("lower_included")) {
                this.child = new RmBoolean(((DvInterval)this.currentRM).isLowerIncluded());
            } else if (this.relativeAql.contains("lower")) {
                this.child = ((DvInterval)this.currentRM).getLower();
            } else if (this.relativeAql.contains("upper")) {
                this.child = ((DvInterval)this.currentRM).getUpper();
            }
            this.parent = this.currentRM;
        } else {
            throw new SdkException(String.format("Can not extract from class %s", this.currentRM.getClass().getSimpleName()));
        }
        if (StringUtils.isNotBlank((CharSequence)childPath.findOtherPredicate("name/value")) && this.child instanceof List && Locatable.class.isAssignableFrom(Walker.ARCHIE_RM_INFO_LOOKUP.getClass(this.childNode.getRmType()))) {
            this.child = ((List)this.child).stream().filter(c -> childPath.findOtherPredicate("name/value").equals(((Locatable)c).getNameAsString())).collect(Collectors.toList());
            if (((List)this.child).isEmpty()) {
                this.child = null;
            }
        }
        if (this.isChoice && this.child instanceof List) {
            this.child = ((List)this.child).stream().filter(c -> Walker.ARCHIE_RM_INFO_LOOKUP.getTypeInfo(c.getClass()).getRmName().equals(this.childNode.getRmType())).collect(Collectors.toList());
            if (((List)this.child).isEmpty()) {
                this.child = null;
            }
        }
        if (this.childNode.getMax() == 1 && this.child instanceof List) {
            this.child = ((List)this.child).isEmpty() ? null : ((List)this.child).get(0);
        }
        if (this.child instanceof Element && !this.childNode.getRmType().equals("ELEMENT")) {
            this.child = ((Element)this.child).getValue();
        }
        return this;
    }

    public FlatPath getParentAql() {
        return new FlatPath(this.parentAql);
    }

    public Object getParent() {
        return this.parent;
    }
}

