/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding.std.umarshal.postprocessor;

import com.nedap.archie.rm.composition.Observation;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.History;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ehrbase.serialisation.flatencoding.std.umarshal.postprocessor.AbstractUnmarshalPostprocessor;

public class ObservationPostprocessor
extends AbstractUnmarshalPostprocessor<Observation> {
    @Override
    public void process(String term, Observation rmObject, Map<String, String> values) {
        if (rmObject.getData() != null) {
            this.setValue(term + "/history_origin", null, values, s -> {
                if (s != null) {
                    rmObject.getData().setOrigin(new DvDateTime(s));
                }
            }, String.class);
        }
        if (rmObject.getData() != null && rmObject.getData().getOrigin().getValue() == null) {
            this.setOrigin((History<ItemStructure>)rmObject.getData());
        }
        if (rmObject.getState() != null) {
            this.setValue(term + "/history_origin", null, values, s -> {
                if (s != null) {
                    rmObject.getState().setOrigin(new DvDateTime(s));
                }
            }, String.class);
        }
        if (rmObject.getState() != null && rmObject.getState().getOrigin().getValue() == null) {
            this.setOrigin((History<ItemStructure>)rmObject.getState());
        }
    }

    public void setOrigin(History<ItemStructure> history) {
        Optional<TemporalAccessor> first = history.getEvents().stream().map(Event::getTime).map(DvDateTime::getValue).filter(Objects::nonNull).sorted().findFirst();
        first.ifPresent(temporalAccessor -> history.setOrigin(new DvDateTime(temporalAccessor)));
    }

    public Class<Observation> getAssociatedClass() {
        return Observation.class;
    }
}

