/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.flatencoding.std.umarshal;

import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.composition.Entry;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.generic.PartyRelated;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.serialisation.flatencoding.std.umarshal.postprocessor.UnmarshalPostprocessor;
import org.ehrbase.serialisation.flatencoding.std.umarshal.rmunmarshaller.DefaultRMUnmarshaller;
import org.ehrbase.serialisation.flatencoding.std.umarshal.rmunmarshaller.RMUnmarshaller;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.serialisation.walker.ToCompositionWalker;
import org.ehrbase.serialisation.walker.defaultvalues.DefaultValues;
import org.ehrbase.util.reflection.ReflectionHelper;
import org.ehrbase.webtemplate.model.WebTemplate;
import org.ehrbase.webtemplate.model.WebTemplateInput;
import org.ehrbase.webtemplate.model.WebTemplateInputValue;
import org.ehrbase.webtemplate.model.WebTemplateNode;

public class StdToCompositionWalker
extends ToCompositionWalker<Map<String, String>> {
    private static final Map<Class<?>, RMUnmarshaller> UNMARSHALLER_MAP = ReflectionHelper.buildMap(RMUnmarshaller.class);
    private static final Map<Class<?>, UnmarshalPostprocessor> POSTPROCESSOR_MAP = ReflectionHelper.buildMap(UnmarshalPostprocessor.class);
    private Set<String> consumedPaths;

    @Override
    public void walk(Composition composition, Map<String, String> object, WebTemplate webTemplate, DefaultValues defaultValues) {
        this.consumedPaths = new HashSet<String>();
        super.walk(composition, object, webTemplate, defaultValues);
    }

    @Override
    protected Map<String, String> extract(Context<Map<String, String>> context, WebTemplateNode child, boolean isChoice, Integer count) {
        Map<String, String> subValues;
        context.getNodeDeque().push(child);
        Integer oldCount = null;
        if (count != null) {
            oldCount = context.getCountMap().get(child);
            context.getCountMap().put(child, count);
        }
        String pathWithoutCount = this.buildNamePath(context, false);
        String path = this.buildNamePath(context, true);
        context.getNodeDeque().remove();
        context.getCountMap().remove(child);
        if (oldCount != null) {
            context.getCountMap().put(child, oldCount);
        }
        if ((subValues = context.getObjectDeque().peek().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(path)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            subValues = context.getObjectDeque().peek().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(pathWithoutCount)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (isChoice && !this.isMatchingNode(subValues, context, child)) {
            subValues = Collections.emptyMap();
        }
        if (!subValues.isEmpty()) {
            return subValues;
        }
        return null;
    }

    private boolean isMatchingNode(Map<String, String> subValues, Context<Map<String, String>> context, WebTemplateNode child) {
        if (child.getRmType().equals("POINT_EVENT")) {
            return subValues.entrySet().stream().allMatch(e -> !((String)e.getKey()).endsWith("width"));
        }
        if (child.getRmType().equals("INTERVAL_EVENT")) {
            return subValues.entrySet().stream().anyMatch(e -> ((String)e.getKey()).endsWith("width"));
        }
        if (this.visitChildren(child)) {
            for (WebTemplateNode n : child.getChildren()) {
                context.getNodeDeque().push(n);
                String path = this.buildNamePath(context, true);
                context.getNodeDeque().remove();
                subValues = subValues.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith(path)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            return subValues.isEmpty();
        }
        if (child.getRmType().equals("DV_CODED_TEXT")) {
            return subValues.entrySet().stream().anyMatch(e -> ((String)e.getKey()).endsWith("code"));
        }
        if (child.getRmType().equals("DV_TEXT")) {
            return subValues.entrySet().stream().allMatch(e -> !((String)e.getKey()).endsWith("code"));
        }
        return true;
    }

    @Override
    protected void preHandle(Context<Map<String, String>> context) {
        if (!this.visitChildren(context.getNodeDeque().peek())) {
            RMUnmarshaller rmUnmarshaller = UNMARSHALLER_MAP.getOrDefault(context.getRmObjectDeque().peek().getClass(), new DefaultRMUnmarshaller());
            String namePath = this.getNamePath(context);
            rmUnmarshaller.handle(namePath, context.getRmObjectDeque().peek(), context.getObjectDeque().peek(), context);
            this.consumedPaths.addAll(rmUnmarshaller.getConsumedPaths());
        }
    }

    @Override
    protected void postHandle(Context<Map<String, String>> context) {
        ArrayList<UnmarshalPostprocessor> postprocessor = new ArrayList<UnmarshalPostprocessor>();
        for (Class<?> currentClass = context.getRmObjectDeque().peek().getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (!POSTPROCESSOR_MAP.containsKey(currentClass)) continue;
            postprocessor.add(POSTPROCESSOR_MAP.get(currentClass));
        }
        String namePath = this.getNamePath(context);
        if (Entry.class.isAssignableFrom(context.getRmObjectDeque().peek().getClass()) && ((Entry)context.getRmObjectDeque().peek()).getSubject() instanceof PartyRelated) {
            Optional.ofNullable(context.getNodeDeque().peek()).flatMap(c -> c.findChildById("subject")).flatMap(c -> c.findChildById("relationship")).stream().map(WebTemplateNode::getInputs).flatMap(Collection::stream).filter(i -> "code".equals(i.getSuffix())).map(WebTemplateInput::getList).map(l -> l.size() == 1 ? (WebTemplateInputValue)l.get(0) : null).filter(Objects::nonNull).findAny().ifPresent(v -> ((PartyRelated)((Entry)context.getRmObjectDeque().peek()).getSubject()).setRelationship(new DvCodedText(v.getLabel(), new CodePhrase(new TerminologyId("openehr"), v.getValue()))));
        }
        postprocessor.forEach(p -> {
            p.process(namePath, context.getRmObjectDeque().peek(), (Map)context.getObjectDeque().peek());
            this.consumedPaths.addAll(p.getConsumedPaths());
        });
    }

    private String getNamePath(Context<Map<String, String>> context) {
        String namePath;
        String finalNamePath = namePath = this.buildNamePath(context, true);
        if (context.getObjectDeque().peek().entrySet().stream().noneMatch(e -> ((String)e.getKey()).startsWith(finalNamePath))) {
            namePath = this.buildNamePath(context, false);
        }
        return namePath;
    }

    @Override
    protected int calculateSize(Context<Map<String, String>> context, WebTemplateNode childNode) {
        Integer oldCount = context.getCountMap().get(childNode);
        context.getCountMap().remove(childNode);
        context.getNodeDeque().push(childNode);
        Integer count = context.getObjectDeque().peek().keySet().stream().filter(s -> StringUtils.startsWith((CharSequence)s, (CharSequence)this.buildNamePath(context, true))).map(s -> StringUtils.substringAfter((String)s, (String)(this.buildNamePath(context, true) + ":"))).map(s -> StringUtils.substringBefore((String)s, (String)"/")).map(s -> StringUtils.substringBefore((String)s, (String)"|")).filter(StringUtils::isNotBlank).map(Integer::parseInt).sorted().reduce((first, second) -> second).map(i -> i + 1).orElse(0);
        if (count == 0 && context.getObjectDeque().peek().keySet().stream().anyMatch(s -> StringUtils.startsWith((CharSequence)s, (CharSequence)this.buildNamePath(context, false)))) {
            count = 1;
        }
        context.getNodeDeque().poll();
        if (oldCount != null) {
            context.getCountMap().put(childNode, oldCount);
        }
        return count;
    }

    public Set<String> getConsumedPaths() {
        return this.consumedPaths;
    }
}

