/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes.datavalues.datetime.time;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.serialisation.attributes.datavalues.datetime.I_PartialTime;
import org.ehrbase.serialisation.attributes.datavalues.datetime.time.StandardPartialTime;

public abstract class PartialTime
implements I_PartialTime {
    String timeZoneString;
    String dvTimeRepresentation;

    protected PartialTime(DvTime dvTime) {
        this.dvTimeRepresentation = dvTime.getValue().toString();
        if (dvTime.getValue().isSupported(ChronoField.OFFSET_SECONDS)) {
            this.timeZoneString = ZoneOffset.from(dvTime.getValue()).toString();
            this.dvTimeRepresentation = StringUtils.remove((String)this.dvTimeRepresentation, (String)this.timeZoneString);
        }
    }

    public static I_PartialTime getInstance(DvTime dvTime) {
        if (dvTime.getValue().toString().contains(":")) {
            return new StandardPartialTime(dvTime);
        }
        throw new IllegalArgumentException("ISO8601 time compact form is not yet supported");
    }

    @Override
    public boolean hasTZString() {
        return this.timeZoneString != null;
    }

    @Override
    public boolean isNonCompactIS8601Representation() {
        return this.dvTimeRepresentation.contains(":");
    }
}

