/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes.datavalues.datetime.datetime;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvDate;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import org.ehrbase.serialisation.attributes.datavalues.datetime.I_DateAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.I_DateTimeAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.I_TimeAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.TemporalAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.date.DvDateAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.time.DvTimeAttributes;

public class DvDateTimeAttributes
extends TemporalAttributes
implements I_DateTimeAttributes {
    protected DvDateTime dvDateTime;
    protected I_DateAttributes datePart;
    protected I_TimeAttributes timePart;
    protected ZoneOffset zoneOffset;

    private DvDateTimeAttributes(DvDateTime dvDateTime, I_DateAttributes datePart, I_TimeAttributes timePart) {
        this.dvDateTime = dvDateTime;
        this.datePart = datePart;
        this.timePart = timePart;
        this.zoneOffset = timePart == null ? null : timePart.getZoneOffset();
    }

    public static DvDateTimeAttributes instanceFromValue(DvDateTime dvDateTime) {
        Comparable<Year> localDate;
        TemporalAccessor actual = dvDateTime.getValue();
        if (actual.isSupported(ChronoField.YEAR) && actual.isSupported(ChronoField.MONTH_OF_YEAR) && actual.isSupported(ChronoField.DAY_OF_MONTH)) {
            localDate = LocalDate.of(actual.get(ChronoField.YEAR), actual.get(ChronoField.MONTH_OF_YEAR), actual.get(ChronoField.DAY_OF_MONTH));
        } else if (actual.isSupported(ChronoField.YEAR) && actual.isSupported(ChronoField.MONTH_OF_YEAR)) {
            localDate = YearMonth.of(actual.get(ChronoField.YEAR), actual.get(ChronoField.MONTH_OF_YEAR));
        } else if (actual.isSupported(ChronoField.YEAR)) {
            localDate = Year.of(actual.get(ChronoField.YEAR));
        } else {
            throw new IllegalArgumentException("DvDateTime supplied is not valid:" + actual);
        }
        DvTimeAttributes dvTimeAttributes = DvTimeAttributes.instanceFromValue(dvDateTime.getValue());
        DvDateAttributes dvDateAttributes = DvDateAttributes.instanceFromValue(new DvDate((Temporal)((Object)localDate)));
        if (dvTimeAttributes == null) {
            dvDateTime = new DvDateTime((TemporalAccessor)dvDateAttributes.getValueAsProvided());
        }
        return new DvDateTimeAttributes(dvDateTime, dvDateAttributes, dvTimeAttributes);
    }

    @Override
    public Long getMagnitude() {
        return LocalDate.from(this.getValueExtended()).toEpochDay();
    }

    @Override
    public Temporal getValueAsProvided() {
        return (Temporal)this.dvDateTime.getValue();
    }

    @Override
    public Temporal getValueExtended() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.datePart.getValueExtended());
        stringBuilder.append("T");
        stringBuilder.append(this.timePart == null ? "00:00:00" : this.timePart.getValueExtended());
        if (this.zoneOffset != null) {
            return OffsetDateTime.parse(stringBuilder.toString());
        }
        return LocalDateTime.parse(stringBuilder.toString());
    }

    @Override
    public Integer getSupportedChronoFields() {
        return 0x4000000 | this.datePart.getSupportedChronoFields() & 0xFEFFFFFF | (this.timePart == null ? 0 : this.timePart.getSupportedChronoFields() & 0xFDFFFFFF);
    }

    @Override
    public Long getTimeStamp() {
        if (this.zoneOffset == null) {
            return LocalDateTime.parse(this.getValueExtended().toString()).toEpochSecond(ZoneOffset.UTC);
        }
        return OffsetDateTime.parse(this.getValueExtended().toString()).toEpochSecond();
    }

    @Override
    public boolean isRmDvDateTime() {
        if (this.timePart == null) {
            return false;
        }
        return this.datePart.isDateYYYYMMDD() && (this.timePart.isTimeHHMMSSmmm() || this.timePart.isTimeHHMMSS());
    }

    @Override
    public boolean isDateTimeYYYY() {
        return this.datePart.isDateYYYY();
    }

    @Override
    public boolean isDateTimeYYYYMM() {
        return this.datePart.isDateYYYYMM();
    }

    @Override
    public boolean isDateTimeYYYYMMDD() {
        return this.datePart.isDateYYYYMMDD();
    }

    @Override
    public boolean isDateTimeYYYYMMDDHH() {
        if (this.timePart == null) {
            return false;
        }
        return this.datePart.isDateYYYYMMDD() && this.timePart.isTimeHH();
    }

    @Override
    public boolean isDateTimeYYYYMMDDHHMM() {
        if (this.timePart == null) {
            return false;
        }
        return this.datePart.isDateYYYYMMDD() && this.timePart.isTimeHHMM();
    }

    @Override
    public boolean isDateTimeYYYYMMDDHHMMSS() {
        if (this.timePart == null) {
            return false;
        }
        return this.datePart.isDateYYYYMMDD() && this.timePart.isTimeHHMMSS();
    }

    @Override
    public boolean isDateTimeYYYYMMDDHHMMSSmmm() {
        if (this.timePart == null) {
            return false;
        }
        return this.datePart.isDateYYYYMMDD() && this.timePart.isTimeHHMMSSmmm();
    }

    @Override
    public ZoneOffset getZoneOffset() {
        return this.zoneOffset;
    }
}

