/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes.datavalues.datetime.date;

import com.nedap.archie.rm.datavalues.quantity.datetime.DvDate;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import org.ehrbase.serialisation.attributes.datavalues.datetime.I_DateAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.TemporalAttributes;
import org.ehrbase.serialisation.attributes.datavalues.datetime.date.DvDateAttributesImp;
import org.ehrbase.serialisation.attributes.datavalues.datetime.date.DvDateYYYYImp;
import org.ehrbase.serialisation.attributes.datavalues.datetime.date.DvDateYYYYMMDDImp;
import org.ehrbase.serialisation.attributes.datavalues.datetime.date.DvDateYYYYMMImp;

public class DvDateAttributes
extends TemporalAttributes
implements I_DateAttributes {
    private I_DateAttributes dateAttributes;

    private DvDateAttributes(I_DateAttributes dateAttributes) {
        this.dateAttributes = dateAttributes;
    }

    public static DvDateAttributes instanceFromValue(DvDate dvDate) {
        DvDateAttributesImp dateAttributes;
        if (dvDate.getValue().isSupported(ChronoField.YEAR) && dvDate.getValue().isSupported(ChronoField.MONTH_OF_YEAR) && dvDate.getValue().isSupported(ChronoField.DAY_OF_MONTH)) {
            dateAttributes = new DvDateYYYYMMDDImp(dvDate);
        } else if (dvDate.getValue().isSupported(ChronoField.YEAR) && dvDate.getValue().isSupported(ChronoField.MONTH_OF_YEAR)) {
            dateAttributes = new DvDateYYYYMMImp(dvDate);
        } else if (dvDate.getValue().isSupported(ChronoField.YEAR)) {
            dateAttributes = new DvDateYYYYImp(dvDate);
        } else {
            throw new IllegalArgumentException("Invalid date:" + dvDate.getValue().toString());
        }
        return new DvDateAttributes(dateAttributes);
    }

    @Override
    public Long getMagnitude() {
        return this.dateAttributes.getMagnitude();
    }

    @Override
    public Temporal getValueAsProvided() {
        return this.dateAttributes.getValueAsProvided();
    }

    @Override
    public Temporal getValueExtended() {
        return this.dateAttributes.getValueExtended();
    }

    @Override
    public Integer getSupportedChronoFields() {
        return this.dateAttributes.getSupportedChronoFields();
    }

    @Override
    public Long getTimeStamp() {
        return null;
    }

    @Override
    public boolean isRmDvDate() {
        return this.dateAttributes.isRmDvDate();
    }

    @Override
    public boolean isDateYYYY() {
        return this.dateAttributes.isDateYYYY();
    }

    @Override
    public boolean isDateYYYYMM() {
        return this.dateAttributes.isDateYYYYMM();
    }

    @Override
    public boolean isDateYYYYMMDD() {
        return this.dateAttributes.isDateYYYYMMDD();
    }
}

