/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.serialisation.attributes;

import com.nedap.archie.rm.composition.IsmTransition;
import com.nedap.archie.rm.datavalues.DvText;
import java.util.ArrayList;
import java.util.Map;
import org.ehrbase.serialisation.dbencoding.PathMap;
import org.ehrbase.serialisation.dbencoding.SimpleClassName;

public class IsmTransitionAttributes {
    private final IsmTransition ismTransition;

    public IsmTransitionAttributes(IsmTransition ismTransition) {
        this.ismTransition = ismTransition;
    }

    public Map<String, Object> toMap() {
        Map<String, Object> valuemap = PathMap.getInstance();
        if (this.ismTransition == null) {
            return null;
        }
        if (this.ismTransition.getReason() != null) {
            ArrayList<Map<String, Object>> reasons = new ArrayList<Map<String, Object>>();
            for (DvText reason : this.ismTransition.getReason()) {
                valuemap.put("/$CLASS$", new SimpleClassName(reason).toString());
                valuemap.put("value", reason.getValue());
                reasons.add(valuemap);
            }
            valuemap.put("reason", reasons);
        }
        if (this.ismTransition.getCareflowStep() != null) {
            valuemap.put("careflow_step", this.ismTransition.getCareflowStep());
        }
        if (this.ismTransition.getCurrentState() != null) {
            valuemap.put("current_state", this.ismTransition.getCurrentState());
        }
        if (this.ismTransition.getTransition() != null) {
            valuemap.put("transition", this.ismTransition.getTransition());
        }
        return valuemap;
    }
}

