/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.openehrclient.defaultrestclient;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.composition.Composition;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.client.annotations.Id;
import org.ehrbase.client.exception.ClientException;
import org.ehrbase.client.flattener.Flattener;
import org.ehrbase.client.flattener.Unflattener;
import org.ehrbase.client.openehrclient.CompositionEndpoint;
import org.ehrbase.client.openehrclient.VersionUid;
import org.ehrbase.client.openehrclient.defaultrestclient.DefaultRestClient;

public class DefaultRestCompositionEndpoint
implements CompositionEndpoint {
    public static final String COMPOSITION_PATH = "/composition/";
    private final DefaultRestClient defaultRestClient;
    private final UUID ehrId;

    public DefaultRestCompositionEndpoint(DefaultRestClient defaultRestClient, UUID ehrId) {
        this.defaultRestClient = defaultRestClient;
        this.ehrId = ehrId;
    }

    static Optional<VersionUid> extractVersionUid(Object entity) {
        return Arrays.stream(entity.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(Id.class)).findAny().map(idField -> {
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(idField.getName(), entity.getClass());
                return (VersionUid)propertyDescriptor.getReadMethod().invoke(entity, new Object[0]);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                throw new ClientException(e.getMessage(), e);
            }
        });
    }

    @Override
    public <T> T mergeCompositionEntity(T entity) {
        Composition composition = (Composition)new Unflattener(this.defaultRestClient.getTemplateProvider(), this.defaultRestClient.getDefaultValuesProvider()).unflatten(entity);
        Optional<VersionUid> versionUid = DefaultRestCompositionEndpoint.extractVersionUid(entity);
        VersionUid updatedVersion = versionUid.isEmpty() ? this.defaultRestClient.httpPost(this.defaultRestClient.getConfig().getBaseUri().resolve("ehr/" + this.ehrId.toString() + COMPOSITION_PATH), (RMObject)composition) : this.defaultRestClient.httpPut(this.defaultRestClient.getConfig().getBaseUri().resolve("ehr/" + this.ehrId.toString() + COMPOSITION_PATH + versionUid.get().getUuid()), (Locatable)composition, versionUid.get());
        Flattener.addVersion(entity, updatedVersion);
        entity = new Flattener(this.defaultRestClient.getTemplateProvider()).flatten((RMObject)composition, entity.getClass());
        Flattener.addVersion(entity, updatedVersion);
        return entity;
    }

    @Override
    public <T> Optional<T> find(UUID compositionId, Class<T> clazz) {
        Optional<Composition> composition = this.defaultRestClient.httpGet(this.defaultRestClient.getConfig().getBaseUri().resolve("ehr/" + this.ehrId.toString() + COMPOSITION_PATH + compositionId.toString()), Composition.class);
        return composition.map(c -> new Flattener(this.defaultRestClient.getTemplateProvider()).flatten((RMObject)c, clazz));
    }
}

