/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.flattener;

import com.google.common.reflect.TypeToken;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.support.identification.ObjectId;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.text.CaseUtils;
import org.ehrbase.client.annotations.Entity;
import org.ehrbase.client.annotations.OptionFor;
import org.ehrbase.client.annotations.Path;
import org.ehrbase.client.classgenerator.EnumValueSet;
import org.ehrbase.client.exception.ClientException;
import org.ehrbase.client.flattener.DtoWithMatchingFields;
import org.ehrbase.client.flattener.PathMatcher;
import org.ehrbase.serialisation.walker.Context;
import org.ehrbase.serialisation.walker.FromCompositionWalker;
import org.ehrbase.serialisation.walker.RmPrimitive;
import org.ehrbase.util.exception.SdkException;
import org.ehrbase.util.reflection.ReflectionHelper;
import org.ehrbase.webtemplate.model.WebTemplateNode;
import org.ehrbase.webtemplate.parser.FlatPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoFromCompositionWalker
extends FromCompositionWalker<DtoWithMatchingFields> {
    private static final PathMatcher PATH_MATCHER = new PathMatcher();
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<Class<?>> dtoClassList;

    static <T> T create(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SdkException(e.getMessage(), (Throwable)e);
        }
    }

    public void walk(RMObject composition, DtoWithMatchingFields object, WebTemplateNode webTemplate) {
        this.dtoClassList = ReflectionHelper.findAll((String)object.getDto().getClass().getPackageName());
        super.walk(composition, (Object)object, webTemplate);
    }

    static Map<String, Field> buildFieldByPathMap(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Path.class)).collect(Collectors.toMap(f -> f.getAnnotation(Path.class).value(), Function.identity()));
    }

    protected DtoWithMatchingFields extract(Context<DtoWithMatchingFields> context, WebTemplateNode child, boolean isChoice, Integer i) {
        Map<String, Field> subValues = ((DtoWithMatchingFields)context.getObjectDeque().peek()).getFieldByPath().entrySet().stream().map(e -> new ImmutablePair((Object)PATH_MATCHER.matchesPath(context, child, (Map.Entry<String, ?>)e), (Object)((Field)e.getValue()))).filter(p -> p.getLeft() != null).collect(Collectors.toMap(ImmutablePair::getLeft, ImmutablePair::getRight));
        if (subValues.isEmpty()) {
            if (List.of("name", "archetype_node_id", "encoding", "archetype_details", "uid").stream().noneMatch(child.getAqlPath()::contains)) {
                this.logger.warn(String.format("Nor Field in dto %s for path %s", ((DtoWithMatchingFields)context.getObjectDeque().peek()).getDto().getClass().getSimpleName(), child.getAqlPath(true)));
            }
            return null;
        }
        if (subValues.size() > 1) {
            if (isChoice && child.getRmType().equals("INTERVAL_EVENT")) {
                this.logger.warn("Path {} is choice but missing OptionFor: Transforming INTERVAL_EVENT to POINT_EVENT ", (Object)child.getAqlPath());
            }
            return new DtoWithMatchingFields(((DtoWithMatchingFields)context.getObjectDeque().peek()).getDto(), subValues);
        }
        Field field = subValues.values().stream().findAny().orElseThrow();
        String path = (String)subValues.keySet().stream().findAny().orElseThrow();
        Class<?> type = field.getType();
        if (List.class.isAssignableFrom(type)) {
            type = TypeToken.of((Type)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]).getRawType();
        }
        if (isChoice) {
            type = this.findActual(type, child.getRmType()).orElseThrow();
        }
        if (type.isAnnotationPresent(Entity.class) && StringUtils.isBlank((CharSequence)path)) {
            Object dto = DtoFromCompositionWalker.create(type);
            this.writeField(field, ((DtoWithMatchingFields)context.getObjectDeque().peek()).getDto(), dto);
            return new DtoWithMatchingFields(dto, DtoFromCompositionWalker.buildFieldByPathMap(type));
        }
        return new DtoWithMatchingFields(((DtoWithMatchingFields)context.getObjectDeque().peek()).getDto(), subValues);
    }

    private void writeField(Field field, Object dto, Object value) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), dto.getClass());
            Object dtoList = value;
            if (EnumValueSet.class.isAssignableFrom(field.getType()) && value != null && CodePhrase.class.isAssignableFrom(value.getClass())) {
                EnumValueSet enumValueSet;
                CodePhrase codePhrase = (CodePhrase)value;
                dtoList = enumValueSet = (EnumValueSet)Arrays.stream(field.getType().getEnumConstants()).map(o -> (EnumValueSet)o).filter(v -> {
                    String terminologyId = Optional.ofNullable(codePhrase.getTerminologyId()).map(ObjectId::getValue).orElse(null);
                    return v.getTerminologyId().equals(terminologyId);
                }).filter(v -> v.getCode().equals(codePhrase.getCodeString())).findAny().orElse(null);
            }
            if (dtoList instanceof RmPrimitive) {
                dtoList = ((RmPrimitive)dtoList).getValue();
            }
            if (List.class.isAssignableFrom(field.getType())) {
                dtoList = propertyDescriptor.getReadMethod().invoke(dto, new Object[0]);
                if (dtoList == null) {
                    dtoList = new ArrayList();
                }
                ((List)dtoList).add(value);
            }
            propertyDescriptor.getWriteMethod().invoke(dto, dtoList);
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    private Object extractAttribute(Object dto, String attributeName) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(attributeName, dto.getClass());
            return propertyDescriptor.getReadMethod().invoke(dto, new Object[0]);
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    private Optional<Class<?>> findActual(Class<?> actualTypeArgument, String simpleName) {
        Optional<Class<?>> aClass = this.dtoClassList.stream().filter(actualTypeArgument::isAssignableFrom).filter(c -> c.isAnnotationPresent(OptionFor.class)).filter(c -> c.getAnnotation(OptionFor.class).value().equals(simpleName)).findAny();
        if (aClass.isEmpty() && !actualTypeArgument.isInterface()) {
            return Optional.of(actualTypeArgument);
        }
        return aClass;
    }

    protected void preHandle(Context<DtoWithMatchingFields> context) {
        Map<String, Field> fieldByPath = ((DtoWithMatchingFields)context.getObjectDeque().peek()).getFieldByPath();
        for (Map.Entry<String, Field> entry : fieldByPath.entrySet()) {
            FlatPath path = new FlatPath(entry.getKey());
            if (!StringUtils.isBlank((CharSequence)path.getName())) continue;
            if (StringUtils.isNotBlank((CharSequence)path.getAttributeName())) {
                this.writeField(entry.getValue(), ((DtoWithMatchingFields)context.getObjectDeque().peek()).getDto(), this.extractAttribute(context.getRmObjectDeque().peek(), CaseUtils.toCamelCase((String)path.getAttributeName(), (boolean)false, (char[])new char[]{'_'})));
                continue;
            }
            this.writeField(entry.getValue(), ((DtoWithMatchingFields)context.getObjectDeque().peek()).getDto(), context.getRmObjectDeque().peek());
        }
    }

    protected void postHandle(Context<DtoWithMatchingFields> context) {
    }
}

