/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.client.aql.condition;

import org.ehrbase.client.aql.condition.Condition;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.field.SelectAqlField;
import org.ehrbase.client.aql.parameter.AqlValue;
import org.ehrbase.client.aql.parameter.Parameter;

public abstract class ComparisonOperator<T>
implements Condition {
    protected final SelectAqlField<T> field;
    protected final AqlValue value;
    protected final Parameter<T> parameter;
    protected final SelectAqlField<T> compereField;

    protected ComparisonOperator(SelectAqlField<T> field, T value) {
        this.field = field;
        this.value = new AqlValue(value);
        this.parameter = null;
        this.compereField = null;
    }

    protected ComparisonOperator(SelectAqlField<T> field, Parameter<T> parameter) {
        this.field = field;
        this.parameter = parameter;
        this.value = null;
        this.compereField = null;
    }

    protected ComparisonOperator(SelectAqlField<T> field, SelectAqlField<T> compereField) {
        this.field = field;
        this.value = null;
        this.parameter = null;
        this.compereField = compereField;
    }

    @Override
    public String buildAql(Containment ehrContainment) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.field.buildAQL(ehrContainment)).append(" ").append(this.getSymbol()).append(" ");
        if (this.value != null) {
            sb.append(this.value.buildAql());
        } else if (this.parameter != null) {
            sb.append(this.parameter.getAqlParameter());
        } else {
            sb.append(this.compereField.buildAQL(ehrContainment));
        }
        return sb.toString();
    }

    protected abstract String getSymbol();
}

