/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.binder;

import java.util.List;
import java.util.Map;
import org.ehrbase.aql.binder.SelectBinder;
import org.ehrbase.aql.dto.orderby.OrderByExpressionDto;
import org.ehrbase.client.aql.containment.Containment;
import org.ehrbase.client.aql.orderby.OrderByExpression;
import org.ehrbase.util.exception.SdkException;

public class OrderByBinder {
    private final SelectBinder selectBinder = new SelectBinder();

    public OrderByExpression bind(List<OrderByExpressionDto> dtoList, Map<Integer, Containment> containmentMap) {
        OrderByExpression orderByExpression = this.bind(dtoList.get(0), containmentMap);
        for (int i = 1; i < dtoList.size(); ++i) {
            orderByExpression = orderByExpression.andThen(this.bind(dtoList.get(i), containmentMap));
        }
        return orderByExpression;
    }

    private OrderByExpression bind(OrderByExpressionDto dto, Map<Integer, Containment> containmentMap) {
        OrderByExpression orderByExpression;
        switch (dto.getSymbol()) {
            case ASC: {
                orderByExpression = OrderByExpression.ascending(this.selectBinder.bind(dto.getStatement(), containmentMap));
                break;
            }
            case DESC: {
                orderByExpression = OrderByExpression.descending(this.selectBinder.bind(dto.getStatement(), containmentMap));
                break;
            }
            default: {
                throw new SdkException(String.format("Unknown Symbol %s", new Object[]{dto.getSymbol()}));
            }
        }
        return orderByExpression;
    }
}

