/*
 * Decompiled with CFR 0.152.
 */
package com.eggheadgames.realmassethelper;

import android.content.Context;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OsUtil {
    private static final String VERSION_PATTERN = "_\\d+\\.realm";
    private String cachedAssetPath;

    public String loadDatabaseToLocalStorage(Context context, String databaseFolder, String databaseName) {
        String asset = this.findAsset(context, databaseFolder, databaseName);
        File file = new File(this.generateDatabaseFileName(context, databaseName));
        if (file.exists()) {
            file.delete();
        }
        try {
            InputStream is = context.getAssets().open(asset);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(buffer);
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return file.getName();
    }

    public String generateDatabaseFileName(Context context, String databaseName) {
        return context.getFilesDir() + File.separator + databaseName + ".realm";
    }

    public String getFileNameForDatabase(Context context, String databaseName) {
        return new File(this.generateDatabaseFileName(context, databaseName)).getName();
    }

    public Integer getCurrentDbVersion(Context context, String databaseName) {
        int currentVersion = PreferenceManager.getDefaultSharedPreferences((Context)context).getInt("android_realm_asset_helper_db_version_" + databaseName, -1);
        return currentVersion == -1 ? null : Integer.valueOf(currentVersion);
    }

    public int getAssetsDbVersion(Context context, String databaseFolder, String databaseName) {
        String dbAsset = this.findAsset(context, databaseFolder, databaseName);
        Pattern pattern = Pattern.compile(VERSION_PATTERN);
        Matcher matcher = pattern.matcher(dbAsset);
        if (matcher.find()) {
            String version = matcher.group().substring(1, matcher.group().indexOf(46));
            return Integer.parseInt(version);
        }
        return 0;
    }

    public void storeDatabaseVersion(Context context, int version, String databaseName) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putInt("android_realm_asset_helper_db_version_" + databaseName, version).commit();
    }

    public boolean isEmpty(String string) {
        return TextUtils.isEmpty((CharSequence)string);
    }

    public boolean isDatabaseAssetExists(Context context, String databaseFolder, String databaseName) {
        return !TextUtils.isEmpty((CharSequence)this.findAsset(context, databaseFolder, databaseName));
    }

    public void clearCache() {
        this.cachedAssetPath = null;
    }

    private String findAsset(Context context, String path, String databaseName) {
        if (!TextUtils.isEmpty((CharSequence)this.cachedAssetPath)) {
            return this.cachedAssetPath;
        }
        try {
            String[] list = context.getAssets().list(path);
            if (list.length > 0) {
                for (String file : list) {
                    if (TextUtils.isEmpty((CharSequence)file) || !file.matches(databaseName + VERSION_PATTERN) && !file.matches(databaseName + ".realm")) continue;
                    this.cachedAssetPath = path + File.separator + file;
                    return path;
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }
}

