/*
 * Decompiled with CFR 0.152.
 */
package edmt.dev.advancednestedscrollview;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;

public class MyViewGroupUtils {
    private static final Matrix sMatrix = new Matrix();
    private static final RectF sRectF = new RectF();
    private static final Matrix sIdentity = new Matrix();
    private static final Rect sRect = new Rect();

    public static boolean isPointInChildBounds(ViewGroup parent, View child, int x, int y) {
        MyViewGroupUtils.getDescendantRect(parent, child, sRect);
        return sRect.contains(x, y);
    }

    private static void getDescendantRect(ViewGroup parent, View descendant, Rect out) {
        out.set(0, 0, descendant.getWidth(), descendant.getHeight());
        MyViewGroupUtils.offsetDescendantRect(parent, descendant, out);
    }

    private static void offsetDescendantRect(ViewGroup parent, View descendant, Rect rect) {
        sMatrix.set(sIdentity);
        MyViewGroupUtils.offsetDescendantMatrix((ViewParent)parent, descendant, sMatrix);
        sRectF.set(rect);
        sMatrix.mapRect(sRectF);
        int left = (int)(MyViewGroupUtils.sRectF.left + 0.5f);
        int top = (int)(MyViewGroupUtils.sRectF.top + 0.5f);
        int right = (int)(MyViewGroupUtils.sRectF.right + 0.5f);
        int bottom = (int)(MyViewGroupUtils.sRectF.bottom + 0.5f);
        rect.set(left, top, right, bottom);
    }

    private static void offsetDescendantMatrix(ViewParent target, View view, Matrix m) {
        ViewParent parent = view.getParent();
        if (parent instanceof View && parent != target) {
            View vp = (View)parent;
            MyViewGroupUtils.offsetDescendantMatrix(target, vp, m);
            m.preTranslate((float)(-vp.getScrollX()), (float)(-vp.getScrollY()));
        }
        m.preTranslate((float)view.getLeft(), (float)view.getTop());
        if (!view.getMatrix().isIdentity()) {
            m.preConcat(view.getMatrix());
        }
    }

    private MyViewGroupUtils() {
    }
}

