/*
 * Decompiled with CFR 0.152.
 */
package vimeoextractor;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vimeoextractor.OnVimeoExtractionListener;
import vimeoextractor.VimeoAPIManager;
import vimeoextractor.VimeoParser;
import vimeoextractor.VimeoVideo;

public class VimeoExtractor {
    private static VimeoExtractor instance;

    private VimeoExtractor() {
    }

    public static VimeoExtractor getInstance() {
        if (instance == null) {
            instance = new VimeoExtractor();
        }
        return instance;
    }

    public void fetchVideoWithIdentifier(@NotNull String identifier, @Nullable String referrer, final @NotNull OnVimeoExtractionListener listener) {
        if (identifier.length() == 0) {
            listener.onFailure(new IllegalArgumentException("Video identifier cannot be empty"));
            return;
        }
        final VimeoAPIManager manager = new VimeoAPIManager();
        try {
            manager.extractWithIdentifier(identifier, referrer).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    listener.onFailure(e);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    if (response.isSuccessful()) {
                        VimeoVideo vimeoVideo = new VimeoVideo(response.body().string());
                        listener.onSuccess(vimeoVideo);
                    } else {
                        listener.onFailure(manager.getError(response));
                    }
                }
            });
        }
        catch (IOException e) {
            listener.onFailure(e);
            e.printStackTrace();
        }
    }

    public void fetchVideoWithURL(@NotNull String videoURL, @Nullable String referrer, @NotNull OnVimeoExtractionListener listener) {
        if (videoURL.length() == 0) {
            listener.onFailure(new IllegalArgumentException("Video URL cannot be empty"));
            return;
        }
        VimeoParser parser = new VimeoParser(videoURL);
        if (!parser.isVimeoURLValid()) {
            listener.onFailure(new IllegalArgumentException("Vimeo URL is not valid"));
            return;
        }
        String identifier = parser.getExtractedIdentifier();
        this.fetchVideoWithIdentifier(identifier, referrer, listener);
    }
}

