/*
 * Decompiled with CFR 0.152.
 */
package pl.exsio.querydsl.entityql.jdbc;

import com.google.common.base.CaseFormat;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;

public class UpperCaseWithUnderscoresNamingStrategy
implements NamingStrategy {
    public String getTableName(Class<?> type) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, type.getSimpleName()) + "S";
    }

    public String getColumnName(RelationalPersistentProperty property) {
        String propertyInLowerUnderscore = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, property.getName());
        if (property.isIdProperty()) {
            return property.getOwner().getType().getSimpleName().toUpperCase() + "_" + propertyInLowerUnderscore;
        }
        return propertyInLowerUnderscore;
    }

    public String getReverseColumnName(PersistentPropertyPathExtension path) {
        return path.getIdColumnName();
    }
}

