/*
 * Decompiled with CFR 0.152.
 */
package pl.exsio.querydsl.entityql;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.springframework.data.annotation.Id;
import pl.exsio.querydsl.entityql.EntityQL;
import pl.exsio.querydsl.entityql.GeneratePluginExtension;
import pl.exsio.querydsl.entityql.Generator;
import pl.exsio.querydsl.entityql.JPAQEntityScannerFactory;
import pl.exsio.querydsl.entityql.QEntityScannerFactory;
import pl.exsio.querydsl.entityql.QExporter;
import pl.exsio.querydsl.entityql.SpringDataJdbcQEntityScannerFactory;
import pl.exsio.querydsl.entityql.entity.scanner.QEntityScanner;

public class GenerateTask
extends DefaultTask {
    private static final EnumMap<Generator.Type, QEntityScannerFactory> SCANNERS = new EnumMap(Generator.Type.class);
    private static final EnumMap<Generator.Type, BiFunction<Generator, URLClassLoader, Set<Class<?>>>> REFLECTION_SCANNERS = new EnumMap(Generator.Type.class);
    private GeneratePluginExtension extension;
    private Set<File> sourcePaths;
    private File baseDir;
    private final QExporter exporter = new QExporter();

    void setExtension(GeneratePluginExtension extension) {
        this.extension = extension;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    @TaskAction
    public void generateModel() throws Exception {
        this.getLogger().info("Running EntityQL Model generation...");
        URLClassLoader classLoader = this.classLoader();
        for (Generator generator : this.getGenerators()) {
            this.generate(generator, classLoader);
        }
    }

    private void generate(Generator generator, URLClassLoader classLoader) throws Exception {
        QEntityScanner scanner = SCANNERS.get((Object)generator.getType()).createScanner(generator.getParams());
        this.getLogger().info("Using scanner: {}", (Object)scanner.getClass().getName());
        generator.setDefaultDestinationPathIfNeeded(this.baseDir.getAbsolutePath());
        this.getLogger().info("Generating EntityQL Static Models from package {} to package {}, destination path: {}", new Object[]{generator.getSourcePackage(), generator.getDestinationPackage(), generator.getDestinationPath()});
        Set<Class<?>> entityClasses = REFLECTION_SCANNERS.get((Object)generator.getType()).apply(generator, classLoader);
        for (String string : generator.getSourceClasses()) {
            entityClasses.add(this.loadClass(classLoader, string));
        }
        this.getLogger().info("Found {} Entity Classes to export in package {}", (Object)entityClasses.size(), (Object)generator.getSourcePackage());
        for (Class clazz : entityClasses) {
            this.getLogger().info("Exporting class: {}", (Object)clazz.getName());
            this.exporter.export(EntityQL.qEntity((Class)clazz, (QEntityScanner)scanner), generator.getFilenamePattern(), generator.getDestinationPackage(), generator.getDestinationPath());
        }
    }

    private URLClassLoader classLoader() throws Exception {
        ArrayList<URL> projectClasspathList = new ArrayList<URL>();
        for (File element : this.sourcePaths) {
            this.getLogger().info("Adding element to Class Loader: {}", (Object)element);
            try {
                projectClasspathList.add(element.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new Exception(element + " is an invalid classpath element", e);
            }
        }
        return new URLClassLoader(projectClasspathList.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    private Class<?> loadClass(URLClassLoader classLoader, String sourceClass) throws Exception {
        return Class.forName(sourceClass, true, classLoader);
    }

    public void setSourcePaths(Set<File> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    @Internal
    public List<Generator> getGenerators() {
        return this.extension.getGenerators();
    }

    private static Set<Class<?>> resolveJpaEntityClasses(Generator generator, URLClassLoader classLoader) {
        Reflections reflections = new Reflections(new Object[]{generator.getSourcePackage(), classLoader});
        return reflections.getTypesAnnotatedWith(Entity.class);
    }

    private static Set<Class<?>> resolveJdbcEntityClasses(Generator generator, URLClassLoader classLoader) {
        Reflections reflections = new Reflections(new Object[]{generator.getSourcePackage(), classLoader, new FieldAnnotationsScanner()});
        Set fieldsAnnotatedWith = reflections.getFieldsAnnotatedWith(Id.class);
        return fieldsAnnotatedWith.stream().map(Field::getDeclaringClass).collect(Collectors.toSet());
    }

    static {
        SCANNERS.put(Generator.Type.JPA, new JPAQEntityScannerFactory());
        SCANNERS.put(Generator.Type.SPRING_DATA_JDBC, new SpringDataJdbcQEntityScannerFactory());
        REFLECTION_SCANNERS.put(Generator.Type.JPA, GenerateTask::resolveJpaEntityClasses);
        REFLECTION_SCANNERS.put(Generator.Type.SPRING_DATA_JDBC, GenerateTask::resolveJdbcEntityClasses);
    }
}

