/*
 * Decompiled with CFR 0.152.
 */
package com.github.dzieciou.testing.curl;

import com.github.dzieciou.testing.curl.CurlCommand;
import com.github.dzieciou.testing.curl.Platform;
import java.util.Optional;
import java.util.function.Consumer;

public class Options {
    private boolean logStacktrace;
    private boolean printMultiliner;
    private boolean useShortForm;
    private Consumer<CurlCommand> curlUpdater;
    private Platform targetPlatform = Platform.RECOGNIZE_AUTOMATICALLY;
    private boolean escapeNonAscii;

    private Options() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean canLogStacktrace() {
        return this.logStacktrace;
    }

    public boolean printMultiliner() {
        return this.printMultiliner;
    }

    public boolean escapeNonAscii() {
        return this.escapeNonAscii;
    }

    public boolean useShortForm() {
        return this.useShortForm;
    }

    public Optional<Consumer<CurlCommand>> getCurlUpdater() {
        return Optional.ofNullable(this.curlUpdater);
    }

    public Platform getTargetPlatform() {
        return this.targetPlatform;
    }

    public static class Builder {
        private final Options options = new Options();

        public Builder logStacktrace() {
            this.options.logStacktrace = true;
            return this;
        }

        public Builder dontLogStacktrace() {
            this.options.logStacktrace = false;
            return this;
        }

        public Builder printMultiliner() {
            this.options.printMultiliner = true;
            return this;
        }

        public Builder printSingleliner() {
            this.options.printMultiliner = false;
            return this;
        }

        public Builder useShortForm() {
            this.options.useShortForm = true;
            return this;
        }

        public Builder useLongForm() {
            this.options.useShortForm = false;
            return this;
        }

        public Builder updateCurl(Consumer<CurlCommand> curlUpdater) {
            this.options.curlUpdater = curlUpdater;
            return this;
        }

        public Builder targetPlatform(Platform targetPlatform) {
            this.options.targetPlatform = targetPlatform;
            return this;
        }

        public Builder escapeNonAscii() {
            this.options.escapeNonAscii = true;
            return this;
        }

        public Builder dontEscapeNonAscii() {
            this.options.escapeNonAscii = false;
            return this;
        }

        public Options build() {
            return this.options;
        }
    }
}

