/*
 * Decompiled with CFR 0.152.
 */
package com.github.dzieciou.testing.curl;

import com.github.dzieciou.testing.curl.CurlCommand;
import com.github.dzieciou.testing.curl.Options;
import io.restassured.internal.multipart.RestAssuredMultiPartEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2Curl {
    private static final Logger log = LoggerFactory.getLogger(Http2Curl.class);
    private final Options options;

    public Http2Curl(Options options) {
        this.options = options;
    }

    private static String getContent(FormBodyPart bodyPart) throws IOException {
        ContentBody content = bodyPart.getBody();
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)content.getContentLength());
        content.writeTo((OutputStream)out);
        return out.toString();
    }

    private static String removeQuotes(String s) {
        return s.replaceAll("^\"|\"$", "");
    }

    private static boolean isBasicAuthentication(Header h) {
        return h.getName().equals("Authorization") && h.getValue().startsWith("Basic");
    }

    private static String getOriginalRequestUri(HttpRequest request) {
        if (request instanceof HttpRequestWrapper) {
            return ((HttpRequestWrapper)request).getOriginal().getRequestLine().getUri();
        }
        if (request instanceof RequestWrapper) {
            return ((RequestWrapper)request).getOriginal().getRequestLine().getUri();
        }
        throw new IllegalArgumentException("Unsupported request class type: " + request.getClass());
    }

    private static String getHost(HttpRequest request) {
        return Http2Curl.tryGetHeaderValue(Arrays.asList(request.getAllHeaders()), "Host").orElseGet(() -> URI.create(Http2Curl.getOriginalRequestUri(request)).getHost());
    }

    private static boolean isValidUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private static Optional<String> tryGetHeaderValue(List<Header> headers, String headerName) {
        return headers.stream().filter(h -> h.getName().equals(headerName)).map(Header::getValue).findFirst();
    }

    private static <T> Object getFieldValue(T obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field f = Http2Curl.getField(obj.getClass(), fieldName);
        f.setAccessible(true);
        return f.get(obj);
    }

    private static Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return Http2Curl.getField(superClass, fieldName);
        }
    }

    public String generateCurl(HttpRequest request) throws Exception {
        CurlCommand curl = this.http2curl(request);
        this.options.getCurlUpdater().ifPresent(updater -> updater.accept(curl));
        return curl.asString(this.options.getTargetPlatform(), this.options.useShortForm(), this.options.printMultiliner(), this.options.escapeNonAscii());
    }

    private CurlCommand http2curl(HttpRequest request) throws NoSuchFieldException, IllegalAccessException, IOException {
        String requestMethod;
        Headers headers = new Headers(Arrays.asList(request.getAllHeaders()));
        CurlCommand curl = new CurlCommand();
        String inferredUri = this.inferUri(request);
        curl.setUrl(inferredUri);
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest requestWithEntity = (HttpEntityEnclosingRequest)request;
            try {
                HttpEntity entity = requestWithEntity.getEntity();
                if (entity != null) {
                    Optional<String> maybeRequestContentType = Http2Curl.tryGetHeaderValue(headers.toProcess, "Content-Type");
                    String contentType = maybeRequestContentType.orElseThrow(() -> new IllegalStateException("Missing Content-Type header"));
                    this.handleEntity(entity, contentType, headers, curl);
                }
            }
            catch (IOException e) {
                log.error("Failed to consume form data (entity) from HTTP request", (Throwable)e);
                throw e;
            }
        }
        if (!("GET".equals(requestMethod = request.getRequestLine().getMethod()) || "POST".equals(requestMethod) && curl.hasData())) {
            curl.setMethod(requestMethod);
        }
        headers.toProcess = this.handleAuthenticationHeader(headers.toProcess, curl);
        List cookiesHeaders = headers.toProcess.stream().filter(h -> h.getName().equals("Cookie")).collect(Collectors.toList());
        if (cookiesHeaders.size() == 1) {
            curl.setCookieHeader(((Header)cookiesHeaders.get(0)).getValue());
            headers.toProcess = headers.toProcess.stream().filter(h -> !h.getName().equals("Cookie")).collect(Collectors.toList());
        } else if (cookiesHeaders.size() > 1) {
            log.warn("More than one Cookie header in HTTP Request not allowed by RFC 6265");
        }
        this.handleNotIgnoredHeaders(headers, curl);
        curl.setCompressed(true);
        curl.setInsecure(true);
        curl.setVerbose(true);
        return curl;
    }

    private void handleEntity(HttpEntity entity, String contentType, Headers headers, CurlCommand curl) throws IOException {
        List<String> parameters = Arrays.asList(contentType.split(";"));
        parameters = parameters.stream().map(s -> s.trim()).collect(Collectors.toList());
        contentType = parameters.remove(0);
        headers.ignored.add("Content-Length");
        switch (contentType) {
            case "multipart/form-data": {
                headers.ignored.add("Content-Type");
                this.handleMultipartEntity(entity, curl);
                break;
            }
            case "multipart/mixed": {
                headers.toProcess = this.filterOutHeader(headers.toProcess, "Content-Type");
                headers.toProcess.add((Header)new BasicHeader("Content-Type", "multipart/mixed"));
                this.handleMultipartEntity(entity, curl);
                break;
            }
            default: {
                String data = EntityUtils.toString((HttpEntity)entity);
                curl.addDataBinary(data);
            }
        }
    }

    private List<Header> filterOutHeader(List<Header> headers, String s) {
        return headers.stream().filter(h -> !h.getName().equals(s)).collect(Collectors.toList());
    }

    private String inferUri(HttpRequest request) {
        String inferredUri = request.getRequestLine().getUri();
        if (!Http2Curl.isValidUrl(inferredUri)) {
            String host = Http2Curl.getHost(request);
            String inferredScheme = "http";
            if (host.endsWith(":443")) {
                inferredScheme = "https";
            } else if ((request instanceof RequestWrapper || request instanceof HttpRequestWrapper) && Http2Curl.getOriginalRequestUri(request).startsWith("https")) {
                inferredScheme = "https";
            }
            inferredUri = "CONNECT".equals(request.getRequestLine().getMethod()) ? String.format("%s://%s", inferredScheme, host) : String.format("%s://%s/%s", inferredScheme, host, inferredUri).replaceAll("(?<!http(s)?:)//", "/");
        }
        return inferredUri;
    }

    private void handleMultipartEntity(HttpEntity entity, CurlCommand curl) {
        try {
            HttpEntity wrappedEntity = (HttpEntity)Http2Curl.getFieldValue(entity, "wrappedEntity");
            RestAssuredMultiPartEntity multiPartEntity = (RestAssuredMultiPartEntity)wrappedEntity;
            MultipartEntityBuilder multipartEntityBuilder = (MultipartEntityBuilder)Http2Curl.getFieldValue(multiPartEntity, "builder");
            List bodyParts = (List)Http2Curl.getFieldValue(multipartEntityBuilder, "bodyParts");
            bodyParts.forEach(p -> this.handlePart((FormBodyPart)p, curl));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private void handlePart(FormBodyPart bodyPart, CurlCommand curl) {
        StringBuilder partContent;
        String partName;
        String contentDisposition = bodyPart.getHeader().getFields().stream().filter(f -> f.getName().equals("Content-Disposition")).findFirst().orElseThrow(() -> new RuntimeException("Multipart missing Content-Disposition header")).getBody();
        List<String> elements = Arrays.asList(contentDisposition.split(";"));
        Map<String, String> map = elements.stream().map(s -> s.trim().split("=")).collect(Collectors.toMap(a -> a[0], a -> ((String[])a).length == 2 ? a[1] : ""));
        if (map.containsKey("form-data")) {
            partName = Http2Curl.removeQuotes(map.get("name"));
            partContent = new StringBuilder();
            if (map.get("filename") != null) {
                partContent.append("@").append(Http2Curl.removeQuotes(map.get("filename")));
            } else {
                try {
                    partContent.append(Http2Curl.getContent(bodyPart));
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read content of the part", e);
                }
            }
        } else {
            throw new RuntimeException("Unsupported type " + map.entrySet().stream().findFirst().get());
        }
        partContent.append(";type=").append(bodyPart.getHeader().getField("Content-Type").getBody());
        curl.addFormPart(partName, partContent.toString());
    }

    private void handleNotIgnoredHeaders(Headers headers, CurlCommand curl) {
        headers.toProcess.stream().filter(h -> !headers.ignored.contains(h.getName())).forEach(h -> curl.addHeader(h.getName(), h.getValue()));
    }

    private List<Header> handleAuthenticationHeader(List<Header> headers, CurlCommand curl) {
        ArrayList<Header> remainingHeaders = new ArrayList<Header>(headers);
        Iterator it = remainingHeaders.iterator();
        while (it.hasNext()) {
            Header h = (Header)it.next();
            if (!Http2Curl.isBasicAuthentication(h)) continue;
            try {
                String credentials = h.getValue().replaceAll("Basic ", "");
                String decodedCredentials = new String(Base64.getDecoder().decode(credentials));
                String[] userAndPassword = decodedCredentials.split(":", -1);
                curl.setServerAuthentication(userAndPassword[0], userAndPassword[1]);
                it.remove();
                break;
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                log.warn("This is not valid Basic authentication header: {}", (Object)h.getValue());
            }
        }
        return remainingHeaders;
    }

    private static class Headers {
        List<Header> toProcess;
        Set<String> ignored;

        public Headers(List<Header> toProcess) {
            this.toProcess = toProcess;
            this.ignored = new HashSet<String>();
        }
    }
}

