/*
 * Decompiled with CFR 0.152.
 */
package com.github.dyvoker.shadow_lib;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import com.github.dyvoker.shadow_lib.ShadowUtils;

public class CanvasWithShadow {
    @NonNull
    private final Bitmap canvasBitmap;
    @NonNull
    private final Canvas canvas;
    private Bitmap bitmapWithShadow;

    public CanvasWithShadow(@NonNull Canvas canvas) {
        this(canvas.getWidth(), canvas.getHeight(), Bitmap.Config.ARGB_8888);
    }

    public CanvasWithShadow(@NonNull Canvas canvas, @NonNull Bitmap.Config config) {
        this(canvas.getWidth(), canvas.getHeight(), config);
    }

    public CanvasWithShadow(int width, int height) {
        this(width, height, Bitmap.Config.ARGB_8888);
    }

    public CanvasWithShadow(int width, int height, @NonNull Bitmap.Config config) {
        this.canvasBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        this.canvas = new Canvas(this.canvasBitmap);
    }

    @NonNull
    public Canvas getCanvas() {
        return this.canvas;
    }

    public void draw(@NonNull Canvas canvas, @ColorInt int shadowColor, float shadowRadiusDp, float offsetXDp, float offsetYDp, boolean forceRedraw) {
        if (this.bitmapWithShadow == null || forceRedraw) {
            if (this.bitmapWithShadow != null) {
                this.bitmapWithShadow.recycle();
            }
            this.bitmapWithShadow = ShadowUtils.addShadow(this.canvasBitmap, shadowColor, shadowRadiusDp, offsetXDp, offsetYDp);
            canvas.drawBitmap(this.bitmapWithShadow, 0.0f, 0.0f, null);
            return;
        }
        canvas.drawBitmap(this.bitmapWithShadow, 0.0f, 0.0f, null);
    }

    public boolean isSameSize(@NonNull Canvas canvas) {
        return this.isSameSize(canvas.getWidth(), canvas.getHeight());
    }

    public boolean isSameSize(int width, int height) {
        if (this.bitmapWithShadow == null) {
            return false;
        }
        int bitmapWidth = this.bitmapWithShadow.getWidth();
        int bitmapHeight = this.bitmapWithShadow.getHeight();
        return bitmapWidth == width && bitmapHeight == height;
    }

    public void recycle() {
        if (this.bitmapWithShadow != null) {
            this.bitmapWithShadow.recycle();
        }
    }
}

