/*
 * Decompiled with CFR 0.152.
 */
package com.github.dyvoker.dialogs.context_menu;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.github.dyvoker.dialogs.R;
import com.github.dyvoker.dialogs.context_menu.ClickListener;
import com.github.dyvoker.dialogs.context_menu.ContextMenuItemWidget;

public class SimpleMenuItem
implements ContextMenuItemWidget {
    @NonNull
    private final View root;
    private ContextMenuItemWidget.DismissListener dismissListener;

    private SimpleMenuItem(@NonNull View root, final @Nullable ClickListener clickListener, final boolean dismissOnClick) {
        this.root = root;
        this.getRoot().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (clickListener != null) {
                    clickListener.onClick();
                }
                if (dismissOnClick && SimpleMenuItem.this.dismissListener != null) {
                    SimpleMenuItem.this.dismissListener.dismissMenu();
                }
            }
        });
    }

    @Override
    public void setDismissListener(@NonNull ContextMenuItemWidget.DismissListener dismissListener) {
        this.dismissListener = dismissListener;
    }

    @Override
    @NonNull
    public View getRoot() {
        return this.root;
    }

    @NonNull
    public static Builder newBuilder(@NonNull Context context, @NonNull CharSequence text) {
        return new Builder(context, text);
    }

    @NonNull
    public static Builder newBuilder(@NonNull View root) {
        return new Builder(root);
    }

    @NonNull
    public static Builder newBuilder(@NonNull Context context, @LayoutRes int layoutId) {
        return new Builder(context, layoutId);
    }

    public static class Builder {
        @NonNull
        private final View root;
        @Nullable
        private ClickListener clickListener;
        private boolean dismissOnClick = true;

        private Builder(@NonNull Context context, @NonNull CharSequence text) {
            LayoutInflater inflater = LayoutInflater.from((Context)context);
            this.root = inflater.inflate(R.layout.dialogs_dyv_text_item, null, false);
            TextView textView = (TextView)this.root.findViewById(R.id.dialogs_dyv_text);
            textView.setText(text);
        }

        private Builder(@NonNull View root) {
            this.root = root;
        }

        private Builder(@NonNull Context context, @LayoutRes int layoutId) {
            LayoutInflater inflater = LayoutInflater.from((Context)context);
            this.root = inflater.inflate(layoutId, null, false);
        }

        @NonNull
        public Builder clickListener(@NonNull ClickListener clickListener) {
            this.clickListener = clickListener;
            return this;
        }

        @NonNull
        public Builder dismissOnClick(boolean dismissOnClick) {
            this.dismissOnClick = dismissOnClick;
            return this;
        }

        @NonNull
        public SimpleMenuItem build() {
            return new SimpleMenuItem(this.root, this.clickListener, this.dismissOnClick);
        }
    }
}

