/*
 * Decompiled with CFR 0.152.
 */
package com.github.dyvoker.dialogs.context_menu;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.dyvoker.dialogs.R;
import com.github.dyvoker.dialogs.context_menu.ContextMenuItemWidget;
import java.util.ArrayList;
import java.util.List;

public class ContextMenuWidget
implements ContextMenuItemWidget.DismissListener {
    @NonNull
    private final Context context;
    @NonNull
    private final List<ContextMenuItemWidget> items;
    @Nullable
    private final CharSequence title;
    @ColorInt
    private final int titleColor;
    private final boolean isCanceledOnTouchOutside;
    private Dialog dialog;

    private ContextMenuWidget(@NonNull Context context, @NonNull List<ContextMenuItemWidget> items, @Nullable CharSequence title, @ColorInt int titleColor, boolean isCanceledOnTouchOutside) {
        this.context = context;
        this.items = items;
        this.title = title;
        this.titleColor = titleColor;
        this.isCanceledOnTouchOutside = isCanceledOnTouchOutside;
    }

    public void show() {
        this.dialog = new Dialog(this.context);
        this.dialog.requestWindowFeature(1);
        this.dialog.setCanceledOnTouchOutside(this.isCanceledOnTouchOutside);
        this.dialog.setContentView(R.layout.dialogs_dyv_context_menu);
        TextView titleView = (TextView)this.dialog.findViewById(R.id.dialogs_dyv_title);
        if (this.title != null) {
            titleView.setText(this.title);
            titleView.setTextColor(this.titleColor);
        } else {
            titleView.setVisibility(8);
        }
        LinearLayout itemsContainer = (LinearLayout)this.dialog.findViewById(R.id.dialogs_dyv_items_container);
        for (ContextMenuItemWidget item : this.items) {
            item.setDismissListener(this);
            itemsContainer.addView(item.getRoot());
        }
        this.dialog.show();
    }

    @Nullable
    public Dialog getDialog() {
        return this.dialog;
    }

    @Override
    public void dismissMenu() {
        this.dialog.dismiss();
    }

    public static Builder newBuilder(@NonNull Context context) {
        return new Builder(context);
    }

    public static class Builder {
        @NonNull
        private final Context context;
        @NonNull
        private final List<ContextMenuItemWidget> items = new ArrayList<ContextMenuItemWidget>();
        @Nullable
        private CharSequence title;
        @ColorInt
        private int titleColor;
        private boolean isCanceledOnTouchOutside;

        private Builder(@NonNull Context context) {
            this.context = context;
            this.titleColorRes(R.color.dialogs_dyv_black);
            this.isCanceledOnTouchOutside = true;
        }

        @NonNull
        public Builder addItem(@NonNull ContextMenuItemWidget item) {
            this.items.add(item);
            return this;
        }

        @NonNull
        public Builder title(@StringRes int title) {
            return this.title(this.context.getString(title));
        }

        @NonNull
        public Builder title(@NonNull CharSequence title) {
            this.title = title;
            return this;
        }

        @NonNull
        public Builder titleColorRes(@ColorRes int color2) {
            return this.titleColor(this.context.getResources().getColor(color2));
        }

        @NonNull
        public Builder titleColor(@ColorInt int color2) {
            this.titleColor = color2;
            return this;
        }

        @NonNull
        public Builder isCanceledOnTouchOutside(boolean isCanceled) {
            this.isCanceledOnTouchOutside = isCanceled;
            return this;
        }

        @NonNull
        public ContextMenuWidget build() {
            return new ContextMenuWidget(this.context, this.items, this.title, this.titleColor, this.isCanceledOnTouchOutside);
        }
    }
}

