/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.webkit.JavascriptInterface;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.herewhite.sdk.Logger;
import com.herewhite.sdk.Player;
import com.herewhite.sdk.PlayerEventListener;
import com.herewhite.sdk.SyncDisplayerState;
import com.herewhite.sdk.domain.EventEntry;
import com.herewhite.sdk.domain.PlayerPhase;
import com.herewhite.sdk.domain.PlayerState;
import com.herewhite.sdk.domain.SDKError;

public class PlayerCallbacksImplement
implements SyncDisplayerState.Listener<PlayerState> {
    private static final Gson gson = new Gson();
    private PlayerEventListener listener;
    private Player player;

    public PlayerEventListener getListener() {
        return this.listener;
    }

    public void setPlayer(Player player) {
        this.player = player;
        this.player.getSyncPlayerState().setListener(this);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setListener(PlayerEventListener listener) {
        this.listener = listener;
    }

    @Override
    public void onDisplayerStateChanged(PlayerState modifyState) {
        if (this.listener != null) {
            try {
                this.listener.onPlayerStateChanged(modifyState);
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onPlayerStateChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void fireMagixEvent(Object args) {
        EventEntry eventEntry = (EventEntry)gson.fromJson(String.valueOf(args), EventEntry.class);
        if (this.player != null) {
            this.player.fireMagixEvent(eventEntry);
        }
    }

    @JavascriptInterface
    public void onPhaseChanged(Object args) {
        PlayerPhase phase = PlayerPhase.valueOf(String.valueOf(args));
        if (this.player != null) {
            this.player.setPlayerPhase(phase);
        }
        if (this.listener != null) {
            try {
                this.listener.onPhaseChanged(phase);
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onPhaseChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void onLoadFirstFrame(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onLoadFirstFrame();
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onLoadFirstFrame method", e);
            }
        }
    }

    @JavascriptInterface
    public void onSliceChanged(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onSliceChanged(String.valueOf(args));
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onSliceChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void onPlayerStateChanged(Object args) {
        this.player.getSyncPlayerState().syncDisplayerState(String.valueOf(args));
    }

    @JavascriptInterface
    public void onStoppedWithError(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onStoppedWithError(this.resolverSDKError(args));
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onStoppedWithError method", e);
            }
        }
    }

    private SDKError resolverSDKError(Object args) {
        JsonObject jsonObject = (JsonObject)gson.fromJson(String.valueOf(args), JsonObject.class);
        String message = jsonObject.get("message").getAsString();
        String jsStack = jsonObject.get("jsStack").getAsString();
        SDKError sdkError = new SDKError(message, jsStack);
        return sdkError;
    }

    @JavascriptInterface
    public void onScheduleTimeChanged(Object args) {
        long scheduleTime = Long.parseLong(String.valueOf(args));
        if (this.player != null) {
            this.player.setScheduleTime(scheduleTime);
        }
        if (this.listener != null) {
            try {
                this.listener.onScheduleTimeChanged(scheduleTime);
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onScheduleTimeChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void onCatchErrorWhenAppendFrame(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onCatchErrorWhenAppendFrame(this.resolverSDKError(args));
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onCatchErrorWhenAppendFrame method", e);
            }
        }
    }

    @JavascriptInterface
    public void onCatchErrorWhenRender(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onCatchErrorWhenRender(this.resolverSDKError(args));
            }
            catch (AssertionError a) {
                throw a;
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onCatchErrorWhenRender method", e);
            }
        }
    }
}

