/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import android.webkit.JavascriptInterface;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.herewhite.sdk.Logger;
import com.herewhite.sdk.Player;
import com.herewhite.sdk.PlayerCallbacksImplement;
import com.herewhite.sdk.PlayerEventListener;
import com.herewhite.sdk.Room;
import com.herewhite.sdk.RoomCallbacks;
import com.herewhite.sdk.RoomCallbacksImplement;
import com.herewhite.sdk.RoomParams;
import com.herewhite.sdk.SyncDisplayerState;
import com.herewhite.sdk.WhiteSdkConfiguration;
import com.herewhite.sdk.WhiteboardView;
import com.herewhite.sdk.domain.PlayerConfiguration;
import com.herewhite.sdk.domain.PlayerState;
import com.herewhite.sdk.domain.PlayerTimeInfo;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.RoomState;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.domain.UrlInterrupter;
import java.util.Map;
import wendu.dsbridge.OnReturnValue;

public class WhiteSdk {
    private static final Gson gson = new Gson();
    private final WhiteboardView bridge;
    private final Context context;
    private final RoomCallbacksImplement roomCallbacksImplement;
    private final PlayerCallbacksImplement playerCallbacksImplement;
    private final boolean onlyCallbackRemoteStateModify;
    private UrlInterrupter urlInterrupter;

    public static String Version() {
        return "2.4.28";
    }

    public WhiteSdk(WhiteboardView bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration) {
        this(bridge, context, whiteSdkConfiguration, null);
    }

    public WhiteSdk(WhiteboardView bridge, Context context, WhiteSdkConfiguration whiteSdkConfiguration, UrlInterrupter urlInterrupter) {
        this.bridge = bridge;
        this.context = context;
        this.urlInterrupter = urlInterrupter;
        this.roomCallbacksImplement = new RoomCallbacksImplement(context);
        this.playerCallbacksImplement = new PlayerCallbacksImplement();
        this.onlyCallbackRemoteStateModify = whiteSdkConfiguration.isOnlyCallbackRemoteStateModify();
        bridge.addJavascriptObject(this, "sdk");
        bridge.addJavascriptObject(this.roomCallbacksImplement, "room");
        bridge.addJavascriptObject(this.playerCallbacksImplement, "player");
        if (whiteSdkConfiguration.isOnlyCallbackRemoteStateModify()) {
            whiteSdkConfiguration.setOnlyCallbackRemoteStateModify(false);
        }
        bridge.callHandler("sdk.newWhiteSdk", new Object[]{whiteSdkConfiguration});
        whiteSdkConfiguration.setOnlyCallbackRemoteStateModify(this.onlyCallbackRemoteStateModify);
    }

    public void joinRoom(RoomParams roomParams, Promise<Room> roomPromise) {
        this.joinRoom(roomParams, null, roomPromise);
    }

    public void joinRoom(final RoomParams roomParams, RoomCallbacks roomCallbacks, final Promise<Room> roomPromise) {
        try {
            if (roomCallbacks != null) {
                this.roomCallbacksImplement.setListener(roomCallbacks);
            }
            this.bridge.callHandler("sdk.joinRoom", new Object[]{roomParams}, new OnReturnValue<String>(){

                public void onValue(String roomString) {
                    JsonObject jsonObject = (JsonObject)gson.fromJson(roomString, JsonObject.class);
                    SDKError promiseError = SDKError.promiseError(jsonObject);
                    if (promiseError != null) {
                        try {
                            roomPromise.catchEx(promiseError);
                        }
                        catch (AssertionError a) {
                            throw a;
                        }
                        catch (Throwable e) {
                            Logger.error("An exception occurred while catch joinRoom method exception", e);
                        }
                    } else {
                        boolean disableCallbackWhilePutting = WhiteSdk.this.onlyCallbackRemoteStateModify;
                        JsonObject jsonState = jsonObject.getAsJsonObject("state");
                        SyncDisplayerState<RoomState> syncRoomState = new SyncDisplayerState<RoomState>(RoomState.class, jsonState.toString(), disableCallbackWhilePutting);
                        Room room = new Room(roomParams.getUuid(), WhiteSdk.this.bridge, WhiteSdk.this.context, WhiteSdk.this, syncRoomState);
                        Long observerId = jsonObject.get("observerId").getAsLong();
                        room.setObserverId(observerId);
                        WhiteSdk.this.roomCallbacksImplement.setRoom(room);
                        roomPromise.then(room);
                    }
                }
            });
        }
        catch (AssertionError a) {
            throw a;
        }
        catch (Exception e) {
            roomPromise.catchEx(new SDKError(e.getMessage()));
        }
    }

    public void createPlayer(PlayerConfiguration playerConfiguration, Promise<Player> playerPromise) {
        this.createPlayer(playerConfiguration, null, playerPromise);
    }

    public void createPlayer(final PlayerConfiguration playerConfiguration, PlayerEventListener playerEventListener, final Promise<Player> playerPromise) {
        try {
            if (playerEventListener != null) {
                this.playerCallbacksImplement.setListener(playerEventListener);
            }
            this.bridge.callHandler("sdk.replayRoom", new Object[]{playerConfiguration}, new OnReturnValue<String>(){

                public void onValue(String roomString) {
                    JsonObject jsonObject = (JsonObject)gson.fromJson(roomString, JsonObject.class);
                    SDKError promiseError = SDKError.promiseError(jsonObject);
                    if (promiseError != null) {
                        try {
                            playerPromise.catchEx(promiseError);
                        }
                        catch (AssertionError a) {
                            throw a;
                        }
                        catch (Throwable e) {
                            Logger.error("An exception occurred while catch createPlayer method exception", e);
                        }
                    } else {
                        JsonObject timeInfo = jsonObject.getAsJsonObject("timeInfo");
                        PlayerTimeInfo playerTimeInfo = (PlayerTimeInfo)gson.fromJson(timeInfo.toString(), PlayerTimeInfo.class);
                        SyncDisplayerState<PlayerState> syncPlayerState = new SyncDisplayerState<PlayerState>(PlayerState.class, "{}", true);
                        Player player = new Player(playerConfiguration.getRoom(), WhiteSdk.this.bridge, WhiteSdk.this.context, WhiteSdk.this, playerTimeInfo, syncPlayerState);
                        WhiteSdk.this.playerCallbacksImplement.setPlayer(player);
                        playerPromise.then(player);
                    }
                }
            });
        }
        catch (AssertionError a) {
            throw a;
        }
        catch (Exception e) {
            playerPromise.catchEx(new SDKError(e.getMessage()));
        }
    }

    public void releaseRoom() {
        this.roomCallbacksImplement.setListener(null);
    }

    public void releaseRoom(String uuid) {
        this.releaseRoom();
    }

    public void releasePlayer() {
        this.playerCallbacksImplement.setListener(null);
    }

    public void releasePlayer(String uuid) {
        this.releasePlayer();
    }

    @JavascriptInterface
    public String urlInterrupter(Object args) {
        if (this.urlInterrupter == null) {
            return String.valueOf(args);
        }
        return this.urlInterrupter.urlInterrupter(String.valueOf(args));
    }

    @JavascriptInterface
    public void throwError(Object args) {
        Logger.info("WhiteSDK JS error: " + gson.fromJson(String.valueOf(args), Map.class));
    }

    @JavascriptInterface
    public void logger(Object args) {
        Logger.info("WhiteSDK logger: " + gson.fromJson(String.valueOf(args), Map.class));
    }
}

