/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk.combinePlayer;

import com.herewhite.sdk.Player;
import com.herewhite.sdk.combinePlayer.NativePlayer;
import com.herewhite.sdk.domain.PlayerPhase;
import java.util.concurrent.TimeUnit;

public class PlayerSyncManager {
    private Player whitePlayer;
    private PauseReason pauseReason = PauseReason.Init;
    private NativePlayer nativePlayer;
    private Callbacks callbacks;

    public PlayerSyncManager(Player whitePlayer, NativePlayer nativePlayer, Callbacks callbacks) {
        this.whitePlayer = whitePlayer;
        this.nativePlayer = nativePlayer;
        this.callbacks = callbacks;
        this.updateNativePhase(nativePlayer.getPhase());
        this.updateWhitePlayerPhase(whitePlayer.getPlayerPhase());
    }

    public PlayerSyncManager(NativePlayer nativePlayer, Callbacks callbacks) {
        this.nativePlayer = nativePlayer;
        this.callbacks = callbacks;
        this.updateNativePhase(nativePlayer.getPhase());
    }

    public void setWhitePlayer(Player whitePlayer) {
        this.whitePlayer = whitePlayer;
        this.updateWhitePlayerPhase(whitePlayer.getPlayerPhase());
    }

    public void play() {
        this.pauseReason = this.pauseReason.removeFlag(PauseReason.Pause);
        this.nativePlayer.play();
        if (this.nativePlayer.hasEnoughBuffer()) {
            this.whitePlayer.play();
        }
    }

    public void pause() {
        this.pauseReason = this.pauseReason.addFlag(PauseReason.Pause);
        this.nativePlayer.pause();
        this.whitePlayer.pause();
    }

    public void seek(long time, TimeUnit timeUnit) {
        Long milliseconds = TimeUnit.MILLISECONDS.convert(time, timeUnit);
        this.whitePlayer.seekToScheduleTime(milliseconds.intValue());
    }

    public void updateNativePhase(NativePlayer.NativePlayerPhase phase) {
        if (phase == NativePlayer.NativePlayerPhase.Buffering || phase == NativePlayer.NativePlayerPhase.Idle) {
            this.nativeStartBuffering();
        } else {
            this.nativeEndBuffering();
        }
    }

    private void nativeStartBuffering() {
        this.pauseReason = this.pauseReason.addFlag(PauseReason.WaitingNativePlayerBuffering);
        this.callbacks.startBuffering();
        this.whitePlayer.pause();
    }

    private void nativeEndBuffering() {
        boolean isBuffering = this.pauseReason.hasFlag(PauseReason.WaitingWhitePlayerBuffering) || this.pauseReason.hasFlag(PauseReason.WaitingNativePlayerBuffering);
        this.pauseReason = this.pauseReason.removeFlag(PauseReason.WaitingNativePlayerBuffering);
        if (this.pauseReason.hasFlag(PauseReason.WaitingWhitePlayerBuffering)) {
            this.nativePlayer.pause();
        } else if (isBuffering) {
            this.callbacks.endBuffering();
        }
        if (this.pauseReason.equals(PauseReason.None)) {
            this.nativePlayer.play();
            this.whitePlayer.play();
        }
    }

    public void updateWhitePlayerPhase(PlayerPhase phase) {
        if (phase == PlayerPhase.buffering || phase == PlayerPhase.waitingFirstFrame) {
            this.whitePlayerStartBuffering();
        } else if (phase == PlayerPhase.pause || phase == PlayerPhase.playing) {
            this.whitePlayerEndBuffering();
        }
    }

    private void whitePlayerStartBuffering() {
        this.pauseReason = this.pauseReason.addFlag(PauseReason.WaitingWhitePlayerBuffering);
        this.nativePlayer.pause();
        this.callbacks.startBuffering();
    }

    private void whitePlayerEndBuffering() {
        boolean isBuffering = this.pauseReason.hasFlag(PauseReason.WaitingWhitePlayerBuffering) || this.pauseReason.hasFlag(PauseReason.WaitingNativePlayerBuffering);
        this.pauseReason = this.pauseReason.removeFlag(PauseReason.WaitingWhitePlayerBuffering);
        if (this.pauseReason.hasFlag(PauseReason.WaitingNativePlayerBuffering)) {
            this.whitePlayer.pause();
        } else if (isBuffering) {
            this.callbacks.endBuffering();
        }
        if (this.pauseReason.equals(PauseReason.None)) {
            this.nativePlayer.play();
            this.whitePlayer.play();
        } else if (this.pauseReason.hasFlag(PauseReason.Pause)) {
            this.nativePlayer.pause();
            this.whitePlayer.pause();
        }
    }

    private static enum PauseReason {
        None(0),
        WaitingWhitePlayerBuffering(1),
        WaitingNativePlayerBuffering(2),
        WaitingBothBuffering(3),
        Pause(4),
        PauseAndWhiteBuffering(5),
        PauseAndNativeBuffering(6),
        PauseAndBothBuffering(7),
        Init(7);

        private int flag;

        private PauseReason(int flag) {
            this.flag = flag;
        }

        public int getValue() {
            return this.flag;
        }

        public boolean equals(PauseReason flag) {
            return flag.getValue() == this.getValue();
        }

        public boolean hasFlag(PauseReason flag) {
            return (this.getValue() & flag.getValue()) != None.getValue();
        }

        public PauseReason removeFlag(PauseReason flag) {
            int value = this.getValue() & ~flag.getValue();
            for (PauseReason p : PauseReason.values()) {
                if (value != p.getValue()) continue;
                return p;
            }
            return None;
        }

        public PauseReason addFlag(PauseReason flag) {
            int value = this.getValue() | flag.getValue();
            for (PauseReason p : PauseReason.values()) {
                if (value != p.getValue()) continue;
                return p;
            }
            return None;
        }
    }

    public static interface Callbacks {
        public void startBuffering();

        public void endBuffering();
    }
}

