/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.herewhite.sdk.Logger;
import com.herewhite.sdk.WhiteBroadView;
import com.herewhite.sdk.WhiteSdk;
import com.herewhite.sdk.domain.EventEntry;
import com.herewhite.sdk.domain.EventListener;
import com.herewhite.sdk.domain.PlayerObserverMode;
import com.herewhite.sdk.domain.PlayerPhase;
import com.herewhite.sdk.domain.PlayerState;
import com.herewhite.sdk.domain.PlayerTimeInfo;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.SDKError;
import java.util.concurrent.ConcurrentHashMap;
import wendu.dsbridge.OnReturnValue;

public class Player {
    private static final Gson gson = new Gson();
    private final String room;
    private final WhiteBroadView bridge;
    private final Context context;
    private final WhiteSdk whiteSdk;
    private ConcurrentHashMap<String, EventListener> eventListenerConcurrentHashMap = new ConcurrentHashMap();

    public Player(String room, WhiteBroadView bridge, Context context, WhiteSdk whiteSdk) {
        this.room = room;
        this.bridge = bridge;
        this.context = context;
        this.whiteSdk = whiteSdk;
    }

    public void play() {
        this.bridge.callHandler("player.play", new Object[0]);
    }

    public void pause() {
        this.bridge.callHandler("player.pause", new Object[0]);
    }

    public void stop() {
        this.bridge.callHandler("player.stop", new Object[0]);
        this.whiteSdk.releasePlayer(this.room);
    }

    public void seekToScheduleTime(long beginTime) {
        this.bridge.callHandler("player.seekToScheduleTime", new Object[]{beginTime});
    }

    public void fireMagixEvent(EventEntry eventEntry) {
        EventListener eventListener = this.eventListenerConcurrentHashMap.get(eventEntry.getEventName());
        if (eventListener != null) {
            try {
                eventListener.onEvent(eventEntry);
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while sending the event", e);
            }
        }
    }

    public void removeMagixEventListener(String eventName) {
        this.eventListenerConcurrentHashMap.remove(eventName);
        this.bridge.callHandler("player.removeMagixEventListener", new Object[]{eventName});
    }

    public void addMagixEventListener(String eventName, EventListener eventListener) {
        this.eventListenerConcurrentHashMap.put(eventName, eventListener);
        this.bridge.callHandler("player.addMagixEventListener", new Object[]{eventName});
    }

    public void setObserverMode(PlayerObserverMode mode) {
        this.bridge.callHandler("player.setObserverMode", new Object[]{mode.name()});
    }

    public void getPhase(final Promise<PlayerPhase> promise) {
        this.bridge.callHandler("player.getBroadcastState", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    promise.then(PlayerPhase.valueOf(String.valueOf(o)));
                }
                catch (AssertionError a) {
                    throw a;
                }
                catch (JsonSyntaxException e) {
                    Logger.error("An JsonSyntaxException occurred while parse json from getPhase", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred in getPhase promise then method", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public void getPlayerState(final Promise<PlayerState> promise) {
        this.bridge.callHandler("player.state.playerState", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    PlayerState playerState = (PlayerState)gson.fromJson(String.valueOf(o), PlayerState.class);
                    promise.then(playerState);
                }
                catch (AssertionError a) {
                    throw a;
                }
                catch (JsonSyntaxException e) {
                    Logger.error("An JsonSyntaxException occurred while parse json from getPlayerState", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred in getPlayerState promise then method", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public void getPlayerTimeInfo(final Promise<PlayerTimeInfo> promise) {
        this.bridge.callHandler("player.state.timeInfo", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    PlayerTimeInfo playerState = (PlayerTimeInfo)gson.fromJson(String.valueOf(o), PlayerTimeInfo.class);
                    promise.then(playerState);
                }
                catch (AssertionError a) {
                    throw a;
                }
                catch (JsonSyntaxException e) {
                    Logger.error("An JsonSyntaxException occurred while parse json from getPlayerTimeInfo", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred in getPlayerTimeInfo promise then method", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }
}

