/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import com.google.gson.Gson;
import com.herewhite.sdk.Logger;
import com.herewhite.sdk.WhiteBroadView;
import com.herewhite.sdk.WhiteSdk;
import com.herewhite.sdk.domain.AkkoEvent;
import com.herewhite.sdk.domain.BroadcastState;
import com.herewhite.sdk.domain.EventEntry;
import com.herewhite.sdk.domain.EventListener;
import com.herewhite.sdk.domain.GlobalState;
import com.herewhite.sdk.domain.ImageInformation;
import com.herewhite.sdk.domain.ImageInformationWithUrl;
import com.herewhite.sdk.domain.MemberState;
import com.herewhite.sdk.domain.Point;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.RoomMember;
import com.herewhite.sdk.domain.RoomMouseEvent;
import com.herewhite.sdk.domain.SDKError;
import com.herewhite.sdk.domain.Scene;
import com.herewhite.sdk.domain.SceneState;
import com.herewhite.sdk.domain.TextareaBox;
import com.herewhite.sdk.domain.ViewMode;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import wendu.dsbridge.OnReturnValue;

public class Room {
    private static final Gson gson = new Gson();
    private final WhiteBroadView bridge;
    private Integer timeDelay;
    private String uuid;
    private final Context context;
    private WhiteSdk sdk;
    private ConcurrentHashMap<String, EventListener> eventListenerConcurrentHashMap = new ConcurrentHashMap();

    public Room(String uuid, WhiteBroadView bridge, Context context, WhiteSdk sdk) {
        this.uuid = uuid;
        this.bridge = bridge;
        this.context = context;
        this.sdk = sdk;
        this.timeDelay = 0;
    }

    public void setGlobalState(GlobalState globalState) {
        this.bridge.callHandler("room.setGlobalState", new Object[]{globalState});
    }

    public void setMemberState(MemberState memberState) {
        this.bridge.callHandler("room.setMemberState", new Object[]{memberState});
    }

    public void setViewMode(ViewMode viewMode) {
        this.bridge.callHandler("room.setViewMode", new Object[]{viewMode.name()});
    }

    public void setViewSize(int width, int height) {
        this.bridge.callHandler("room.setViewSize", new Object[]{width, height});
    }

    public void disconnect() {
        this.bridge.callHandler("room.disconnect", new Object[0]);
        this.sdk.releaseRoom(this.uuid);
    }

    public void updateTextarea(TextareaBox textareaBox) {
        this.bridge.callHandler("room.updateTextarea", new Object[]{textareaBox});
    }

    public void insertImage(ImageInformation imageInfo) {
        this.bridge.callHandler("room.insertImage", new Object[]{imageInfo});
    }

    public void completeImageUpload(String uuid, String url) {
        this.bridge.callHandler("room.completeImageUpload", new Object[]{uuid, url});
    }

    public void insertImage(ImageInformationWithUrl imageInformationWithUrl) {
        ImageInformation imageInformation = new ImageInformation();
        String uuid = UUID.randomUUID().toString();
        imageInformation.setUuid(uuid);
        imageInformation.setCenterX(imageInformationWithUrl.getCenterX());
        imageInformation.setCenterY(imageInformationWithUrl.getCenterY());
        imageInformation.setHeight(imageInformationWithUrl.getHeight());
        imageInformation.setWidth(imageInformationWithUrl.getWidth());
        this.insertImage(imageInformation);
        this.completeImageUpload(uuid, imageInformationWithUrl.getUrl());
    }

    public void getGlobalState(final Promise<GlobalState> promise) {
        this.bridge.callHandler("room.getGlobalState", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    promise.then(gson.fromJson(String.valueOf(o), GlobalState.class));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred while resolve getGlobalState method promise", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public void getMemberState(final Promise<MemberState> promise) {
        this.bridge.callHandler("room.getMemberState", new OnReturnValue<String>(){

            public void onValue(String o) {
                try {
                    promise.then(gson.fromJson(String.valueOf(o), MemberState.class));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred while resolve getMemberState method promise", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public void getRoomMembers(final Promise<RoomMember[]> promise) {
        this.bridge.callHandler("room.getRoomMembers", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    promise.then(gson.fromJson(String.valueOf(o), RoomMember[].class));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred while resolve getRoomMembers method promise", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public void getSceneState(final Promise<SceneState> promise) {
        this.bridge.callHandler("room.getSceneState", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    promise.then(gson.fromJson(String.valueOf(o), SceneState.class));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred while resolve getRoomMembers method promise", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public void getScenes(final Promise<Scene[]> promise) {
        this.bridge.callHandler("room.getScenes", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    promise.then(gson.fromJson(String.valueOf(o), Scene[].class));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred while resolve getRoomMembers method promise", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public void setScenePath(String path) {
        this.bridge.callHandler("room.setScenePath", new Object[]{path});
    }

    public void putScenes(String dir, Scene[] scenes, int index) {
        this.bridge.callHandler("room.putScenes", new Object[]{dir, scenes, index});
    }

    public void moveScene(String source, String target) {
        this.bridge.callHandler("room.moveScene", new Object[]{source, target});
    }

    public void removeScenes(String dirOrPath) {
        this.bridge.callHandler("room.removeScenes", new Object[]{dirOrPath});
    }

    public void getBroadcastState(final Promise<BroadcastState> promise) {
        this.bridge.callHandler("room.getBroadcastState", new Object[0], new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    promise.then(gson.fromJson(String.valueOf(o), BroadcastState.class));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred while resolve getBroadcastState method promise", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public void zoomChange(double scale) {
        this.bridge.callHandler("room.zoomChange", new Object[]{scale});
    }

    public void disableOperations(boolean disableOperations) {
        this.bridge.callHandler("room.disableOperations", new Object[]{disableOperations});
    }

    public void convertToPointInWorld(double x, double y, final Promise<Point> promise) {
        this.bridge.callHandler("room.convertToPointInWorld", new Object[]{x, y}, new OnReturnValue<Object>(){

            public void onValue(Object o) {
                try {
                    promise.then(gson.fromJson(String.valueOf(o), Point.class));
                }
                catch (Throwable e) {
                    Logger.error("An exception occurred while resolve convertToPointInWorld method promise", e);
                    promise.catchEx(new SDKError(e.getMessage()));
                }
            }
        });
    }

    public void fireMagixEvent(EventEntry eventEntry) {
        EventListener eventListener = this.eventListenerConcurrentHashMap.get(eventEntry.getEventName());
        if (eventListener != null) {
            try {
                eventListener.onEvent(eventEntry);
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while sending the event", e);
            }
        }
    }

    public void dispatchMagixEvent(AkkoEvent eventEntry) {
        this.bridge.callHandler("room.dispatchMagixEvent", new Object[]{eventEntry});
    }

    public void addMagixEventListener(String eventName, EventListener eventListener) {
        this.eventListenerConcurrentHashMap.put(eventName, eventListener);
        this.bridge.callHandler("room.addMagixEventListener", new Object[]{eventName});
    }

    public void removeMagixEventListener(String eventName) {
        this.eventListenerConcurrentHashMap.remove(eventName);
        this.bridge.callHandler("room.removeMagixEventListener", new Object[]{eventName});
    }

    public void setTimeDelay(Integer timeDelay) {
        this.bridge.callHandler("room.setTimeDelay", new Object[]{timeDelay * 1000});
        this.timeDelay = timeDelay;
    }

    public Integer getTimeDelay() {
        return this.timeDelay;
    }

    public void externalDeviceEventDown(RoomMouseEvent mouseEvent) {
        this.bridge.callHandler("room.externalDeviceEventDown", new Object[]{mouseEvent});
    }

    public void externalDeviceEventMove(RoomMouseEvent mouseEvent) {
        this.bridge.callHandler("room.externalDeviceEventMove", new Object[]{mouseEvent});
    }

    public void externalDeviceEventUp(RoomMouseEvent mouseEvent) {
        this.bridge.callHandler("room.externalDeviceEventUp", new Object[]{mouseEvent});
    }

    public void externalDeviceEventLeave(RoomMouseEvent mouseEvent) {
        this.bridge.callHandler("room.externalDeviceEventLeave", new Object[]{mouseEvent});
    }
}

