/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.webkit.JavascriptInterface;
import com.google.gson.Gson;
import com.herewhite.sdk.Logger;
import com.herewhite.sdk.Room;
import com.herewhite.sdk.RoomCallbacks;
import com.herewhite.sdk.domain.EventEntry;
import com.herewhite.sdk.domain.FrameError;
import com.herewhite.sdk.domain.RoomPhase;
import com.herewhite.sdk.domain.RoomState;
import com.herewhite.sdk.domain.UpdateCursor;

public class RoomCallbacksImplement {
    private static final Gson gson = new Gson();
    private RoomCallbacks listener;
    private Room room;

    public RoomCallbacks getListener() {
        return this.listener;
    }

    public void setListener(RoomCallbacks listener) {
        this.listener = listener;
    }

    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    @JavascriptInterface
    public void fireMagixEvent(Object args) {
        EventEntry eventEntry = (EventEntry)gson.fromJson(String.valueOf(args), EventEntry.class);
        if (this.room != null) {
            this.room.fireMagixEvent(eventEntry);
        }
    }

    @JavascriptInterface
    public void firePhaseChanged(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onPhaseChanged(RoomPhase.valueOf(String.valueOf(args)));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onPhaseChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void fireKickedWithReason(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onKickedWithReason(String.valueOf(args));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onKickedWithReason method", e);
            }
        }
    }

    @JavascriptInterface
    public void fireDisconnectWithError(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onDisconnectWithError(new Exception(String.valueOf(args)));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onDisconnectWithError method", e);
            }
        }
    }

    @JavascriptInterface
    public void fireRoomStateChanged(Object args) {
        RoomState roomState = (RoomState)gson.fromJson(String.valueOf(args), RoomState.class);
        if (this.listener != null) {
            try {
                this.listener.onRoomStateChanged(roomState);
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onRoomStateChanged method", e);
            }
        }
    }

    @JavascriptInterface
    public void fireBeingAbleToCommitChange(Object args) {
        if (this.listener != null) {
            try {
                this.listener.onBeingAbleToCommitChange(Boolean.valueOf(String.valueOf(args)));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onBeingAbleToCommitChange method", e);
            }
        }
    }

    @JavascriptInterface
    public void fireCatchErrorWhenAppendFrame(Object args) {
        FrameError frameError = (FrameError)gson.fromJson(String.valueOf(args), FrameError.class);
        if (this.listener != null) {
            try {
                this.listener.onCatchErrorWhenAppendFrame(frameError.getUserId(), new Exception(frameError.getError()));
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onCatchErrorWhenAppendFrame method", e);
            }
        }
    }

    @JavascriptInterface
    public void onCursorViewsUpdate(Object args) {
        if (this.listener != null) {
            try {
                UpdateCursor updateCursor = (UpdateCursor)gson.fromJson(String.valueOf(args), UpdateCursor.class);
                this.listener.onCursorViewsUpdate(updateCursor);
            }
            catch (Throwable e) {
                Logger.error("An exception occurred while invoke onCursorViewsUpdate method", e);
            }
        }
    }
}

