/*
 * Decompiled with CFR 0.152.
 */
package com.herewhite.sdk;

import android.content.Context;
import com.google.gson.Gson;
import com.herewhite.sdk.WhiteBroadView;
import com.herewhite.sdk.domain.BroadcastState;
import com.herewhite.sdk.domain.GlobalState;
import com.herewhite.sdk.domain.ImageInformation;
import com.herewhite.sdk.domain.LinearTransformationDescription;
import com.herewhite.sdk.domain.MemberState;
import com.herewhite.sdk.domain.PptPage;
import com.herewhite.sdk.domain.Promise;
import com.herewhite.sdk.domain.RoomMember;
import com.herewhite.sdk.domain.TextareaBox;
import com.herewhite.sdk.domain.ViewMode;
import wendu.dsbridge.OnReturnValue;

public class Room {
    private static final Gson gson = new Gson();
    private final WhiteBroadView bridge;
    private final Context context;

    public Room(WhiteBroadView bridge, Context context) {
        this.bridge = bridge;
        this.context = context;
    }

    public void setGlobalState(GlobalState globalState) {
        this.bridge.callHandler("room.setGlobalState", new Object[]{gson.toJson((Object)globalState)});
    }

    public void setMemberState(MemberState memberState) {
        this.bridge.callHandler("room.setMemberState", new Object[]{gson.toJson((Object)memberState)});
    }

    public void setViewMode(ViewMode viewMode) {
        this.bridge.callHandler("room.setViewMode", new Object[]{gson.toJson((Object)viewMode)});
    }

    public void setViewSize(int width, int height) {
        this.bridge.callHandler("room.setViewSize", new Object[]{width, height});
    }

    public void disconnect() {
        this.bridge.callHandler("room.disconnect", new Object[0]);
    }

    public void updateTextarea(TextareaBox textareaBox) {
        this.bridge.callHandler("room.updateTextarea", new Object[]{gson.toJson((Object)textareaBox)});
    }

    public void insertNewPage(int index) {
        this.bridge.callHandler("room.insertNewPage", new Object[]{index});
    }

    public void removePage(int index) {
        this.bridge.callHandler("room.removePage", new Object[]{index});
    }

    public void insertImage(ImageInformation imageInfo) {
        this.bridge.callHandler("room.removePage", new Object[]{gson.toJson((Object)imageInfo)});
    }

    public void pushPptPages(PptPage[] pages) {
        this.bridge.callHandler("room.pushPptPages", new Object[]{gson.toJson((Object)pages)});
    }

    public void completeImageUpload(String uuid, String url) {
        this.bridge.callHandler("room.completeImageUpload", new Object[]{uuid, url});
    }

    public void getGlobalState(final Promise<GlobalState> promise) {
        this.bridge.callHandler("room.getGlobalState", new Object[0], (OnReturnValue)new OnReturnValue<Object>(){

            public void onValue(Object o) {
                promise.then(gson.fromJson(String.valueOf(o), GlobalState.class));
            }
        });
    }

    public void getMemberState(final Promise<MemberState> promise) {
        this.bridge.callHandler("room.getMemberState", (OnReturnValue)new OnReturnValue<String>(){

            public void onValue(String o) {
                promise.then(gson.fromJson(String.valueOf(o), MemberState.class));
            }
        });
    }

    public void getRoomMembers(final Promise<RoomMember[]> promise) {
        this.bridge.callHandler("room.getRoomMembers", new Object[0], (OnReturnValue)new OnReturnValue<Object>(){

            public void onValue(Object o) {
                promise.then(gson.fromJson(String.valueOf(o), RoomMember[].class));
            }
        });
    }

    public void getPptImages(final Promise<String[]> promise) {
        this.bridge.callHandler("room.getPptImages", new Object[0], (OnReturnValue)new OnReturnValue<Object>(){

            public void onValue(Object o) {
                promise.then(gson.fromJson(String.valueOf(o), String[].class));
            }
        });
    }

    public void getTransform(final Promise<LinearTransformationDescription> promise) {
        this.bridge.callHandler("room.getTransform", new Object[0], (OnReturnValue)new OnReturnValue<Object>(){

            public void onValue(Object o) {
                promise.then(gson.fromJson(String.valueOf(o), LinearTransformationDescription.class));
            }
        });
    }

    public void getBroadcastState(final Promise<BroadcastState> promise) {
        this.bridge.callHandler("room.getBroadcastState", new Object[0], (OnReturnValue)new OnReturnValue<Object>(){

            public void onValue(Object o) {
                promise.then(gson.fromJson(String.valueOf(o), BroadcastState.class));
            }
        });
    }

    public void convertToPointInWorld() {
    }
}

