/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;

public class ResizeSurfaceView
extends SurfaceView {
    private int mVideoWidth;
    private int mVideoHeight;
    private int screenType;

    public ResizeSurfaceView(Context context) {
        super(context);
    }

    public ResizeSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setVideoSize(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.getHolder().setFixedSize(width, height);
    }

    public void setScreenScale(int type) {
        this.screenType = type;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = ResizeSurfaceView.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = ResizeSurfaceView.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        switch (this.screenType) {
            case 4: {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                break;
            }
            case 1: {
                if (height > width / 16 * 9) {
                    height = width / 16 * 9;
                    break;
                }
                width = height / 9 * 16;
                break;
            }
            case 2: {
                if (height > width / 4 * 3) {
                    height = width / 4 * 3;
                    break;
                }
                width = height / 3 * 4;
                break;
            }
            case 3: {
                width = widthMeasureSpec;
                height = heightMeasureSpec;
                break;
            }
            default: {
                if (this.mVideoWidth <= 0 || this.mVideoHeight <= 0) break;
                int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                    height = heightSpecSize;
                    width = widthSpecSize;
                    if (this.mVideoWidth * height < width * this.mVideoHeight) {
                        width = height * this.mVideoWidth / this.mVideoHeight;
                        break;
                    }
                    if (this.mVideoWidth * height <= width * this.mVideoHeight) break;
                    height = width * this.mVideoHeight / this.mVideoWidth;
                    break;
                }
                if (widthSpecMode == 0x40000000) {
                    width = widthSpecSize;
                    height = width * this.mVideoHeight / this.mVideoWidth;
                    if (heightSpecMode != Integer.MIN_VALUE || height <= heightSpecSize) break;
                    height = heightSpecSize;
                    break;
                }
                if (heightSpecMode == 0x40000000) {
                    height = heightSpecSize;
                    width = height * this.mVideoWidth / this.mVideoHeight;
                    if (widthSpecMode != Integer.MIN_VALUE || width <= widthSpecSize) break;
                    width = widthSpecSize;
                    break;
                }
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * this.mVideoWidth / this.mVideoHeight;
                }
                if (widthSpecMode != Integer.MIN_VALUE || width <= widthSpecSize) break;
                width = widthSpecSize;
                height = width * this.mVideoHeight / this.mVideoWidth;
            }
        }
        this.setMeasuredDimension(width, height);
    }
}

