/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.player;

import android.media.MediaPlayer;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.dueeeke.videoplayer.listener.MediaEngineInterface;
import com.dueeeke.videoplayer.player.BaseMediaEngine;
import java.io.IOException;

public class AndroidMediaEngine
extends BaseMediaEngine {
    public MediaPlayer mMediaPlayer;
    private MediaEngineInterface mMediaEngineInterface;
    private MediaPlayer.OnErrorListener onErrorListener = (mp, framework_err, impl_err) -> {
        if (this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onError();
        }
        return true;
    };
    private MediaPlayer.OnCompletionListener onCompletionListener = mp -> {
        if (this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onCompletion();
        }
    };
    private MediaPlayer.OnInfoListener onInfoListener = (mp, what, extra) -> {
        if (this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onInfo(what, extra);
        }
        return true;
    };
    private MediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener = (mp, percent) -> {
        if (this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onBufferingUpdate(percent);
        }
    };
    private MediaPlayer.OnPreparedListener onPreparedListener = mp -> {
        if (this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onPrepared();
        }
    };
    private MediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener = (mp, width, height) -> {
        int videoWidth = mp.getVideoWidth();
        int videoHeight = mp.getVideoHeight();
        if (videoWidth != 0 && videoHeight != 0 && this.mMediaEngineInterface != null) {
            this.mMediaEngineInterface.onVideoSizeChanged(videoWidth, videoHeight);
        }
    };

    @Override
    public void start() {
        this.mMediaPlayer.start();
    }

    @Override
    public void initPlayer() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnErrorListener(this.onErrorListener);
            this.mMediaPlayer.setOnCompletionListener(this.onCompletionListener);
            this.mMediaPlayer.setOnInfoListener(this.onInfoListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.onBufferingUpdateListener);
            this.mMediaPlayer.setOnPreparedListener(this.onPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.onVideoSizeChangedListener);
        }
    }

    @Override
    public void setDataSource(String path) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mMediaPlayer.setDataSource(path);
    }

    @Override
    public void pause() {
        this.mMediaPlayer.pause();
    }

    @Override
    public void stop() {
        this.mMediaPlayer.stop();
    }

    @Override
    public void prepareAsync() {
        this.mMediaPlayer.prepareAsync();
    }

    @Override
    public void reset() {
        this.mMediaPlayer.setVolume(1.0f, 1.0f);
        this.mMediaPlayer.reset();
    }

    @Override
    public boolean isPlaying() {
        return this.mMediaPlayer.isPlaying();
    }

    @Override
    public void seekTo(long time) {
        this.mMediaPlayer.seekTo((int)time);
    }

    @Override
    public void release() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
        }
    }

    @Override
    public long getCurrentPosition() {
        return this.mMediaPlayer.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        return this.mMediaPlayer.getDuration();
    }

    @Override
    public void setSurface(Surface surface) {
        this.mMediaPlayer.setSurface(surface);
    }

    @Override
    public void setDisplay(SurfaceHolder holder) {
        this.mMediaPlayer.setDisplay(holder);
    }

    @Override
    public void setVolume(int v1, int v2) {
        this.mMediaPlayer.setVolume((float)v1, (float)v2);
    }

    public void setMediaEngineInterface(MediaEngineInterface mediaEngineInterface) {
        this.mMediaEngineInterface = mediaEngineInterface;
    }
}

