/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import top.defaults.view.BackgroundEffect;
import top.defaults.view.RippleDrawableProxy;
import top.defaults.view.TextButton;

public class RippleEffect
implements BackgroundEffect {
    private TextButton textButton;
    private Drawable ownLayer;

    @Override
    public void init(TextButton textButton) {
        Drawable.ConstantState state;
        Drawable mask;
        this.restore();
        this.textButton = textButton;
        Drawable background = textButton.getBackgroundProxy().getRoot();
        Drawable drawable = mask = background instanceof DrawableContainer ? background.getCurrent() : background;
        if (mask instanceof ShapeDrawable) {
            state = mask.getConstantState();
            if (state != null) {
                ShapeDrawable drawable2 = (ShapeDrawable)state.newDrawable().mutate();
                drawable2.getPaint().setColor(0x43FFFFFF);
                mask = drawable2;
            }
        } else if (mask instanceof GradientDrawable) {
            state = mask.getConstantState();
            if (state != null) {
                GradientDrawable drawable3 = (GradientDrawable)state.newDrawable().mutate();
                drawable3.setColor(0x43FFFFFF);
                mask = drawable3;
            }
        } else {
            mask = new ColorDrawable(0x43FFFFFF);
        }
        ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{{16842919}, new int[0]}, new int[]{textButton.pressedRippleColor, textButton.defaultRippleColor});
        this.ownLayer = new RippleDrawableProxy(colorStateList, null, mask).get();
        textButton.setBackgroundWithProxy(textButton.getBackgroundProxy().addLayer(this.ownLayer));
    }

    public void restore() {
        if (this.textButton != null) {
            this.textButton.setBackgroundWithProxy(this.textButton.getBackgroundProxy().removeLayer(this.ownLayer));
        }
    }

    @Override
    public void actionDown() {
    }

    @Override
    public void actionUp() {
    }
}

