/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LayerDrawableProxy {
    private LayerDrawable layerDrawable;
    private List<Drawable> layers = new ArrayList<Drawable>();

    LayerDrawableProxy(Drawable ... layers) {
        this(new ArrayList<Drawable>(Arrays.asList(layers)));
    }

    private LayerDrawableProxy(List<Drawable> layers) {
        for (int i = layers.size() - 1; i >= 0; --i) {
            if (layers.get(i) != null) continue;
            layers.remove(i);
        }
        this.layerDrawable = new LayerDrawable(layers.toArray(new Drawable[layers.size()]));
        this.layers.addAll(layers);
    }

    public LayerDrawableProxy clear() {
        this.layers.clear();
        this.layerDrawable = new LayerDrawable(this.layers.toArray(new Drawable[this.layers.size()]));
        return this;
    }

    public LayerDrawableProxy addLayer(Drawable layer) {
        if (layer == null) {
            return this;
        }
        this.layers.add(layer);
        if (Build.VERSION.SDK_INT >= 23) {
            this.layerDrawable.addLayer(layer);
        } else {
            this.layerDrawable = new LayerDrawable(this.layers.toArray(new Drawable[this.layers.size()]));
        }
        return this;
    }

    public LayerDrawableProxy removeLayer(Drawable layer) {
        if (layer != null) {
            this.layers.remove(layer);
            this.layerDrawable = new LayerDrawable(this.layers.toArray(new Drawable[this.layers.size()]));
        }
        return this;
    }

    public LayerDrawable get() {
        return this.layers.size() > 0 ? this.layerDrawable : null;
    }

    public Drawable getRoot() {
        return this.layers.size() > 0 ? this.layers.get(0) : null;
    }
}

