/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.FloatEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.view.ViewGroup;
import top.defaults.view.EffectSettings;
import top.defaults.view.TextButton;
import top.defaults.view.TextButtonEffect;

public class AnimateTextSizeEffect
implements TextButtonEffect {
    private ValueAnimator pressSizeAnimation;
    private TextButton textButton;
    private ViewGroup.LayoutParams layoutParams;
    private int originWidth;
    private int originHeight;
    private float originTextSize;
    private Runnable reverseAnimation;

    @Override
    public void init(final TextButton textButton) {
        this.textButton = textButton;
        this.originTextSize = textButton.getTextSize();
        this.pressSizeAnimation = ValueAnimator.ofObject((TypeEvaluator)new FloatEvaluator(), (Object[])new Object[]{Float.valueOf(this.originTextSize), Math.max((double)(this.originTextSize - 4.0f), (double)textButton.getTextSize() * 0.9)});
        EffectSettings.apply(this.pressSizeAnimation, textButton.getSettings());
        this.pressSizeAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                AnimateTextSizeEffect.this.textButton.setTextSize(0, ((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        this.pressSizeAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation, boolean isReverse) {
                if (!isReverse) {
                    TextButton textButton2 = AnimateTextSizeEffect.this.textButton;
                    AnimateTextSizeEffect.this.layoutParams = textButton2.getLayoutParams();
                    AnimateTextSizeEffect.this.originWidth = ((AnimateTextSizeEffect)AnimateTextSizeEffect.this).layoutParams.width;
                    AnimateTextSizeEffect.this.originHeight = ((AnimateTextSizeEffect)AnimateTextSizeEffect.this).layoutParams.height;
                    ((AnimateTextSizeEffect)AnimateTextSizeEffect.this).layoutParams.width = textButton2.getWidth();
                    ((AnimateTextSizeEffect)AnimateTextSizeEffect.this).layoutParams.height = textButton2.getHeight();
                    textButton2.setLayoutParams(AnimateTextSizeEffect.this.layoutParams);
                }
            }

            public void onAnimationEnd(Animator animation, boolean isReverse) {
                if (isReverse && AnimateTextSizeEffect.this.layoutParams != null) {
                    ((AnimateTextSizeEffect)AnimateTextSizeEffect.this).layoutParams.width = AnimateTextSizeEffect.this.originWidth;
                    ((AnimateTextSizeEffect)AnimateTextSizeEffect.this).layoutParams.height = AnimateTextSizeEffect.this.originHeight;
                    AnimateTextSizeEffect.this.textButton.setLayoutParams(AnimateTextSizeEffect.this.layoutParams);
                }
            }

            public void onAnimationCancel(Animator animation) {
                textButton.setTextSize(AnimateTextSizeEffect.this.originTextSize);
            }
        });
    }

    @Override
    public void actionDown() {
        this.pressSizeAnimation.cancel();
        this.textButton.removeCallbacks(this.reverseAnimation);
        this.pressSizeAnimation.start();
    }

    @Override
    public void actionUp() {
        this.reverseAnimation = new Runnable(){

            @Override
            public void run() {
                AnimateTextSizeEffect.this.pressSizeAnimation.reverse();
            }
        };
        this.textButton.postDelayed(this.reverseAnimation, this.pressSizeAnimation.getDuration() - this.pressSizeAnimation.getCurrentPlayTime());
    }
}

