/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import top.defaults.view.EffectSettings;
import top.defaults.view.TextButton;
import top.defaults.view.TextButtonEffect;

public class AnimateTextColorEffect
implements TextButtonEffect {
    private ValueAnimator pressColorAnimation;
    private TextButton textButton;
    private Runnable reverseAnimation;

    @Override
    public void init(final TextButton textButton) {
        this.textButton = textButton;
        this.pressColorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{textButton.defaultTextColor, textButton.pressedTextColor});
        EffectSettings.apply(this.pressColorAnimation, textButton.getSettings());
        this.pressColorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                AnimateTextColorEffect.this.textButton.setTextColor((Integer)animation.getAnimatedValue());
            }
        });
        this.pressColorAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation, boolean isReverse) {
                if (isReverse) {
                    textButton.setDefaultTextColorState();
                }
            }

            public void onAnimationCancel(Animator animation) {
                textButton.setDefaultTextColorState();
            }
        });
    }

    @Override
    public void actionDown() {
        this.pressColorAnimation.cancel();
        this.textButton.removeCallbacks(this.reverseAnimation);
        this.pressColorAnimation.start();
    }

    @Override
    public void actionUp() {
        this.reverseAnimation = new Runnable(){

            @Override
            public void run() {
                AnimateTextColorEffect.this.pressColorAnimation.reverse();
            }
        };
        this.textButton.postDelayed(this.reverseAnimation, this.pressColorAnimation.getDuration() - this.pressColorAnimation.getCurrentPlayTime());
    }
}

