/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.drawabletoolbox;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RotateDrawable;
import android.os.Build;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002\u001a=\u0010\t\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u000b\u001a\u00020\u00072\u001a\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00010\r\"\u0006\u0012\u0002\b\u00030\u0001H\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002\u001a\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0019\u001a\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u001b\u001a\u0016\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001b\u001a\u0016\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001e\u001a\u0016\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001e\u001a\u0016\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001b\u001a\u0016\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\"\u001a\u0016\u0010#\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u001b\u001a\u0016\u0010$\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u001b\u001a\u0016\u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001e\u001a\u0016\u0010&\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001e\u001a\u0016\u0010'\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001b\u001a\u0016\u0010(\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u001b\u001a\u0016\u0010)\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020*\"\u0012\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"gradientState", "Ljava/lang/Class;", "rotateState", "resolveField", "Ljava/lang/reflect/Field;", "source", "fieldName", "", "resolveGradientState", "resolveMethod", "Ljava/lang/reflect/Method;", "methodName", "parameterTypes", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "resolveRotateState", "setColors", "", "drawable", "Landroid/graphics/drawable/GradientDrawable;", "value", "", "setDrawable", "rotateDrawable", "Landroid/graphics/drawable/RotateDrawable;", "Landroid/graphics/drawable/Drawable;", "setFromDegrees", "", "setGradientRadius", "setGradientRadiusType", "", "setInnerRadius", "setInnerRadiusRatio", "setOrientation", "Landroid/graphics/drawable/GradientDrawable$Orientation;", "setPivotX", "setPivotY", "setStrokeColor", "setThickness", "setThicknessRatio", "setToDegrees", "setUseLevelForShape", "", "drawabletoolbox_release"})
public final class CompatibleKt {
    private static final Class<?> gradientState = CompatibleKt.resolveGradientState();
    private static final Class<?> rotateState = CompatibleKt.resolveRotateState();

    private static final Class<?> resolveGradientState() {
        Class<?>[] classes = GradientDrawable.class.getDeclaredClasses();
        int n = classes.length;
        for (int i = 0; i < n; ++i) {
            Class<?> singleClass;
            Class<?> clazz = singleClass = classes[i];
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"singleClass");
            if (!Intrinsics.areEqual((Object)clazz.getSimpleName(), (Object)"GradientState")) continue;
            return singleClass;
        }
        throw (Throwable)new RuntimeException("GradientState could not be found in current GradientDrawable implementation");
    }

    private static final Class<?> resolveRotateState() {
        Class<?>[] classes = RotateDrawable.class.getDeclaredClasses();
        int n = classes.length;
        for (int i = 0; i < n; ++i) {
            Class<?> singleClass;
            Class<?> clazz = singleClass = classes[i];
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"singleClass");
            if (!Intrinsics.areEqual((Object)clazz.getSimpleName(), (Object)"RotateState")) continue;
            return singleClass;
        }
        throw (Throwable)new RuntimeException("RotateState could not be found in current RotateDrawable implementation");
    }

    private static final Field resolveField(Class<?> source, String fieldName) throws SecurityException, NoSuchFieldException {
        Field field;
        Field field2 = field = source.getDeclaredField(fieldName);
        Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
        field2.setAccessible(true);
        return field;
    }

    private static final Method resolveMethod(Class<?> source, String methodName, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        Method method;
        Method method2 = method = source.getDeclaredMethod(methodName, Arrays.copyOf(parameterTypes, parameterTypes.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
        method2.setAccessible(true);
        return method;
    }

    public static final void setInnerRadius(@NotNull GradientDrawable drawable, int value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field innerRadius = CompatibleKt.resolveField(gradientState, "mInnerRadius");
            innerRadius.setInt(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setInnerRadiusRatio(@NotNull GradientDrawable drawable, float value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field innerRadius = CompatibleKt.resolveField(gradientState, "mInnerRadiusRatio");
            innerRadius.setFloat(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setThickness(@NotNull GradientDrawable drawable, int value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field innerRadius = CompatibleKt.resolveField(gradientState, "mThickness");
            innerRadius.setInt(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setThicknessRatio(@NotNull GradientDrawable drawable, float value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field innerRadius = CompatibleKt.resolveField(gradientState, "mThicknessRatio");
            innerRadius.setFloat(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setUseLevelForShape(@NotNull GradientDrawable drawable, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field useLevelForShape = CompatibleKt.resolveField(gradientState, "mUseLevelForShape");
            useLevelForShape.setBoolean(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setOrientation(@NotNull GradientDrawable drawable, @NotNull GradientDrawable.Orientation value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (Build.VERSION.SDK_INT >= 16) {
            drawable.setOrientation(value);
        } else {
            try {
                Field orientation = CompatibleKt.resolveField(gradientState, "mOrientation");
                orientation.set(drawable.getConstantState(), value);
                Field rectIdDirty = CompatibleKt.resolveField(GradientDrawable.class, "mRectIsDirty");
                rectIdDirty.setBoolean(drawable, true);
                drawable.invalidateSelf();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void setColors(@NotNull GradientDrawable drawable, @NotNull int[] value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (Build.VERSION.SDK_INT >= 16) {
            drawable.setColors(value);
        } else {
            try {
                Field colors = CompatibleKt.resolveField(gradientState, "mColors");
                colors.set(drawable.getConstantState(), value);
                drawable.invalidateSelf();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void setGradientRadiusType(@NotNull GradientDrawable drawable, int value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field type = CompatibleKt.resolveField(gradientState, "mGradientRadiusType");
            type.setInt(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setGradientRadius(@NotNull GradientDrawable drawable, float value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field gradientRadius = CompatibleKt.resolveField(gradientState, "mGradientRadius");
            gradientRadius.setFloat(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setStrokeColor(@NotNull GradientDrawable drawable, int value) {
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        try {
            Field type = CompatibleKt.resolveField(gradientState, "mStrokeColor");
            type.setInt(drawable.getConstantState(), value);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static final void setDrawable(@NotNull RotateDrawable rotateDrawable, @NotNull Drawable drawable) {
        Intrinsics.checkParameterIsNotNull((Object)rotateDrawable, (String)"rotateDrawable");
        Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
        if (Build.VERSION.SDK_INT >= 23) {
            rotateDrawable.setDrawable(drawable);
        } else {
            try {
                Field drawableField = CompatibleKt.resolveField(rotateState, "mDrawable");
                drawableField.set(rotateDrawable.getConstantState(), drawable);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void setPivotX(@NotNull RotateDrawable rotateDrawable, float value) {
        Intrinsics.checkParameterIsNotNull((Object)rotateDrawable, (String)"rotateDrawable");
        if (Build.VERSION.SDK_INT >= 21) {
            rotateDrawable.setPivotX(value);
        } else {
            try {
                Field pivotXField = CompatibleKt.resolveField(rotateState, "mPivotX");
                pivotXField.setFloat(rotateDrawable.getConstantState(), value);
                Field pivotXRelField = CompatibleKt.resolveField(rotateState, "mPivotXRel");
                pivotXRelField.setBoolean(rotateDrawable.getConstantState(), true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void setPivotY(@NotNull RotateDrawable rotateDrawable, float value) {
        Intrinsics.checkParameterIsNotNull((Object)rotateDrawable, (String)"rotateDrawable");
        if (Build.VERSION.SDK_INT >= 21) {
            rotateDrawable.setPivotY(value);
        } else {
            try {
                Field pivotYField = CompatibleKt.resolveField(rotateState, "mPivotY");
                pivotYField.setFloat(rotateDrawable.getConstantState(), value);
                Field pivotYRelField = CompatibleKt.resolveField(rotateState, "mPivotYRel");
                pivotYRelField.setBoolean(rotateDrawable.getConstantState(), true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void setFromDegrees(@NotNull RotateDrawable rotateDrawable, float value) {
        Intrinsics.checkParameterIsNotNull((Object)rotateDrawable, (String)"rotateDrawable");
        if (Build.VERSION.SDK_INT >= 21) {
            rotateDrawable.setFromDegrees(value);
        } else {
            try {
                Field fromDegreesField = CompatibleKt.resolveField(rotateState, "mFromDegrees");
                fromDegreesField.setFloat(rotateDrawable.getConstantState(), value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static final void setToDegrees(@NotNull RotateDrawable rotateDrawable, float value) {
        Intrinsics.checkParameterIsNotNull((Object)rotateDrawable, (String)"rotateDrawable");
        if (Build.VERSION.SDK_INT >= 21) {
            rotateDrawable.setToDegrees(value);
        } else {
            try {
                Field toDegreesField = CompatibleKt.resolveField(rotateState, "mToDegrees");
                toDegreesField.setFloat(rotateDrawable.getConstantState(), value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

