/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.content.Context;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.OrientationEventListener;

abstract class DisplayOrientationDetector {
    private final OrientationEventListener orientationEventListener;
    private static final SparseIntArray DISPLAY_ORIENTATIONS = new SparseIntArray();
    private Display display;
    private int lastKnownDisplayOrientation = 0;

    public DisplayOrientationDetector(Context context) {
        this.orientationEventListener = new OrientationEventListener(context){
            private int lastKnownRotation;
            {
                this.lastKnownRotation = -1;
            }

            public void onOrientationChanged(int orientation) {
                if (orientation == -1 || DisplayOrientationDetector.this.display == null) {
                    return;
                }
                int rotation = DisplayOrientationDetector.this.display.getRotation();
                if (this.lastKnownRotation != rotation) {
                    this.lastKnownRotation = rotation;
                    DisplayOrientationDetector.this.dispatchOnDisplayOrientationChanged(DISPLAY_ORIENTATIONS.get(rotation));
                }
            }
        };
    }

    public void enable(Display display) {
        this.display = display;
        this.orientationEventListener.enable();
        this.dispatchOnDisplayOrientationChanged(DISPLAY_ORIENTATIONS.get(display.getRotation()));
    }

    public void disable() {
        this.orientationEventListener.disable();
        this.display = null;
    }

    public int getLastKnownDisplayOrientation() {
        return this.lastKnownDisplayOrientation;
    }

    private void dispatchOnDisplayOrientationChanged(int displayOrientation) {
        this.lastKnownDisplayOrientation = displayOrientation;
        this.onDisplayOrientationChanged(displayOrientation);
    }

    abstract void onDisplayOrientationChanged(int var1);

    static {
        DISPLAY_ORIENTATIONS.put(0, 0);
        DISPLAY_ORIENTATIONS.put(1, 90);
        DISPLAY_ORIENTATIONS.put(2, 180);
        DISPLAY_ORIENTATIONS.put(3, 270);
    }
}

