/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.ImageReader;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.SparseIntArray;
import android.view.OrientationEventListener;
import android.view.Surface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import top.defaults.camera.AspectRatio;
import top.defaults.camera.AutoFitTextureView;
import top.defaults.camera.CameraView;
import top.defaults.camera.Error;
import top.defaults.camera.ImageCaptureCallback;
import top.defaults.camera.ImageSaver;
import top.defaults.camera.InternalPhotographer;
import top.defaults.camera.Photographer;
import top.defaults.camera.Size;
import top.defaults.camera.SizeMap;
import top.defaults.camera.Utils;
import top.defaults.camera.Values;

public class Camera2Photographer
implements InternalPhotographer {
    private static final boolean DEBUG = false;
    private static final int CALLBACK_ON_DEVICE_CONFIGURED = 1;
    private static final int CALLBACK_ON_PREVIEW_STARTED = 2;
    private static final int CALLBACK_ON_PREVIEW_STOPPED = 3;
    private static final int CALLBACK_ON_START_RECORDING = 4;
    private static final int CALLBACK_ON_FINISH_RECORDING = 5;
    private static final int CALLBACK_ON_SHOT_FINISHED = 6;
    private static final int CALLBACK_ON_ERROR = 7;
    private static final int MAX_VIDEO_HEIGHT = 1080;
    private static final SparseIntArray INTERNAL_FACINGS = new SparseIntArray();
    private static final int FOCUS_AREA_SIZE = 150;
    private static final int SENSOR_ORIENTATION_DEFAULT_DEGREES = 90;
    private static final int SENSOR_ORIENTATION_INVERSE_DEGREES = 270;
    private static final SparseIntArray DEFAULT_ORIENTATIONS;
    private static final SparseIntArray INVERSE_ORIENTATIONS;
    private Activity activityContext;
    private CameraView preview;
    private AutoFitTextureView textureView;
    private CallbackHandler callbackHandler;
    private OrientationEventListener orientationEventListener;
    private boolean isInitialized;
    private boolean isPreviewStarted;
    private int mode = 0;
    private AspectRatio aspectRatio = Values.DEFAULT_ASPECT_RATIO;
    private boolean autoFocus = true;
    private int facing = 0;
    private int flash = 0;
    private boolean isManualFocusEngaged;
    private HandlerThread backgroundThread;
    private Handler backgroundHandler;
    private SizeMap previewSizeMap = new SizeMap();
    private SortedSet<Size> supportedPreviewSizes = new TreeSet<Size>();
    private Size previewSize;
    private SizeMap imageSizeMap = new SizeMap();
    private SortedSet<Size> supportedImageSizes = new TreeSet<Size>();
    private Size imageSize;
    private SizeMap videoSizeMap = new SizeMap();
    private SortedSet<Size> supportedVideoSizes = new TreeSet<Size>();
    private Size videoSize;
    private CameraManager cameraManager;
    private CameraDevice camera;
    private CameraCaptureSession captureSession;
    private CaptureRequest.Builder previewRequestBuilder;
    private String cameraId;
    private CameraCharacteristics characteristics;
    private Integer sensorOrientation;
    private int currentDeviceRotation = -1;
    private ImageReader imageReader;
    private MediaRecorder mediaRecorder;
    private String nextImageAbsolutePath;
    private String nextVideoAbsolutePath;
    private boolean isRecordingVideo;
    private static final ArrayList<String> RECORD_VIDEO_PERMISSIONS;
    private final CameraDevice.StateCallback cameraDeviceCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice camera) {
            Camera2Photographer.this.camera = camera;
            Camera2Photographer.this.startCaptureSession();
        }

        public void onDisconnected(@NonNull CameraDevice camera) {
            camera.close();
            Camera2Photographer.this.camera = null;
            Camera2Photographer.this.callbackHandler.onPreviewStopped();
        }

        public void onError(@NonNull CameraDevice camera, int error) {
            Camera2Photographer.this.stopPreview();
            Camera2Photographer.this.callbackHandler.onError(new Error(1));
        }
    };
    private final CameraCaptureSession.StateCallback sessionCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(@NonNull CameraCaptureSession session) {
            Camera2Photographer.this.captureSession = session;
            Camera2Photographer.this.updateAutoFocus();
            Camera2Photographer.this.updateFlash();
            Camera2Photographer.this.updatePreview(null);
            Camera2Photographer.this.callbackHandler.onPreviewStarted();
        }

        public void onConfigureFailed(@NonNull CameraCaptureSession session) {
            Camera2Photographer.this.stopPreview();
            Camera2Photographer.this.callbackHandler.onError(new Error(1));
        }

        public void onClosed(@NonNull CameraCaptureSession session) {
            if (Camera2Photographer.this.captureSession != null && Camera2Photographer.this.captureSession.equals(session)) {
                Camera2Photographer.this.captureSession = null;
            }
        }
    };
    private ImageCaptureCallback imageCaptureCallback = new ImageCaptureCallback(){

        @Override
        public void onPrecaptureRequired() {
            Camera2Photographer.this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.setState(3);
            try {
                Camera2Photographer.this.captureSession.capture(Camera2Photographer.this.previewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this, null);
                Camera2Photographer.this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)0);
            }
            catch (CameraAccessException e) {
                Camera2Photographer.this.callbackHandler.onError(new Error(1, (Throwable)e));
            }
        }

        @Override
        public void onReady() {
            Camera2Photographer.this.captureStillPicture();
        }
    };
    private final ImageReader.OnImageAvailableListener onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            Camera2Photographer.this.backgroundHandler.post((Runnable)new ImageSaver(reader.acquireLatestImage(), Camera2Photographer.this.nextImageAbsolutePath));
        }
    };

    @Override
    public void initWithViewfinder(Activity activity, CameraView preview) {
        this.activityContext = activity;
        this.preview = preview;
        this.textureView = preview.getTextureView();
        this.cameraManager = (CameraManager)activity.getSystemService("camera");
        this.callbackHandler = new CallbackHandler((Context)this.activityContext);
        this.textureView.addCallback(this::startCaptureSession);
        this.orientationEventListener = new OrientationEventListener((Context)this.activityContext){
            private int changeSlop;
            {
                this.changeSlop = 10;
            }

            public void onOrientationChanged(int orientation) {
                if (this.shouldChange(orientation)) {
                    int rotation = 0;
                    if (orientation >= 0 && orientation < 45 || orientation >= 315 && orientation < 360) {
                        rotation = 0;
                    } else if (orientation >= 45 && orientation < 135) {
                        rotation = 3;
                    } else if (orientation >= 135 && orientation < 225) {
                        rotation = 2;
                    } else if (orientation >= 225 && orientation < 315) {
                        rotation = 1;
                    }
                    Camera2Photographer.this.currentDeviceRotation = rotation;
                }
            }

            private boolean shouldChange(int orientation) {
                if (Camera2Photographer.this.currentDeviceRotation == -1) {
                    return true;
                }
                if (Camera2Photographer.this.currentDeviceRotation == 0) {
                    return orientation >= 45 + this.changeSlop && orientation < 315 - this.changeSlop;
                }
                int upLimit = Camera2Photographer.this.currentDeviceRotation + 45 + this.changeSlop;
                int downLimit = Camera2Photographer.this.currentDeviceRotation - 45 - this.changeSlop;
                return orientation < downLimit || orientation >= upLimit;
            }
        };
        this.isInitialized = true;
    }

    private void throwIfNotInitialized() {
        if (!this.isInitialized) {
            throw new RuntimeException("Camera2Photographer is not initialized");
        }
    }

    private void throwIfNoMediaRecorder() {
        if (this.mediaRecorder == null) {
            throw new RuntimeException("MediaRecorder is not initialized");
        }
    }

    @Override
    public Set<Size> getSupportedImageSizes() {
        return this.supportedImageSizes;
    }

    @Override
    public Set<Size> getSupportedVideoSizes() {
        return this.supportedVideoSizes;
    }

    @Override
    public void startPreview() {
        this.throwIfNotInitialized();
        for (String permission2 : RECORD_VIDEO_PERMISSIONS) {
            int permissionCheck = ContextCompat.checkSelfPermission((Context)this.activityContext, (String)permission2);
            if (permissionCheck == 0) continue;
            this.callbackHandler.onError(new Error(3, "Unsatisfied permission: " + permission2));
            return;
        }
        this.startBackgroundThread();
        if (!this.chooseCameraIdByFacing()) {
            this.callbackHandler.onError(new Error(1));
            return;
        }
        if (!this.collectCameraInfo()) {
            return;
        }
        this.prepareWorkers();
        this.callbackHandler.onDeviceConfigured();
        this.startOpeningCamera();
        if (this.orientationEventListener != null) {
            this.orientationEventListener.enable();
        }
        this.isPreviewStarted = true;
    }

    private boolean chooseCameraIdByFacing() {
        try {
            int internalFacing = INTERNAL_FACINGS.get(this.facing);
            String[] ids = this.cameraManager.getCameraIdList();
            if (ids.length == 0) {
                this.callbackHandler.onError(new Error(1, "No camera available."));
                return false;
            }
            for (String id2 : ids) {
                CameraCharacteristics characteristics = this.cameraManager.getCameraCharacteristics(id2);
                Integer level = (Integer)characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                if (level == null || level == 2) continue;
                Integer internal = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (internal == null) {
                    this.callbackHandler.onError(new Error(1, "Unexpected state: LENS_FACING null."));
                    return false;
                }
                if (internal != internalFacing) continue;
                this.cameraId = id2;
                this.characteristics = characteristics;
                return true;
            }
            this.cameraId = ids[0];
            this.characteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
            Integer level = (Integer)this.characteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            if (level == null || level == 2) {
                return false;
            }
            Integer internal = (Integer)this.characteristics.get(CameraCharacteristics.LENS_FACING);
            if (internal == null) {
                this.callbackHandler.onError(new Error(1, "Unexpected state: LENS_FACING null."));
                return false;
            }
            int count = INTERNAL_FACINGS.size();
            for (int i = 0; i < count; ++i) {
                if (INTERNAL_FACINGS.valueAt(i) != internal.intValue()) continue;
                this.facing = INTERNAL_FACINGS.keyAt(i);
                return true;
            }
            this.facing = 0;
            return true;
        }
        catch (CameraAccessException e) {
            this.callbackHandler.onError(new Error(1, (Throwable)e));
            return false;
        }
    }

    private void resetSizes() {
        this.aspectRatio = null;
        this.imageSize = null;
        this.videoSize = null;
    }

    private boolean collectCameraInfo() {
        StreamConfigurationMap map = (StreamConfigurationMap)this.characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        this.sensorOrientation = (Integer)this.characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        if (map == null) {
            this.callbackHandler.onError(new Error(1, "Cannot get available preview/video sizes"));
            return false;
        }
        this.collectPreviewSizes(map);
        this.collectImageSizes(map);
        this.collectVideoSizes(map);
        this.refineSizes();
        return true;
    }

    private void prepareWorkers() {
        Size size;
        SortedSet<Size> sizesWithAspectRatio;
        if (this.mode == 0) {
            if (this.imageSize == null) {
                sizesWithAspectRatio = this.imageSizeMap.sizes(this.aspectRatio);
                this.imageSize = sizesWithAspectRatio != null && sizesWithAspectRatio.size() > 0 ? sizesWithAspectRatio.last() : this.imageSizeMap.defaultSize();
            }
            size = this.imageSize;
            this.imageReader = ImageReader.newInstance((int)this.imageSize.getWidth(), (int)this.imageSize.getHeight(), (int)256, (int)2);
            this.imageReader.setOnImageAvailableListener(this.onImageAvailableListener, null);
        } else if (this.mode == 1) {
            if (this.videoSize == null) {
                sizesWithAspectRatio = this.videoSizeMap.sizes(this.aspectRatio);
                this.videoSize = sizesWithAspectRatio != null && sizesWithAspectRatio.size() > 0 ? sizesWithAspectRatio.last() : Camera2Photographer.chooseVideoSize(this.supportedVideoSizes);
            }
            size = this.videoSize;
            this.mediaRecorder = new MediaRecorder();
        } else {
            throw new RuntimeException("Wrong mode value: " + this.mode);
        }
        this.previewSize = this.chooseOptimalPreviewSize(size);
        int orientation = this.activityContext.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            this.textureView.setAspectRatio(this.previewSize.getWidth(), this.previewSize.getHeight());
        } else {
            this.textureView.setAspectRatio(this.previewSize.getHeight(), this.previewSize.getWidth());
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void startOpeningCamera() {
        try {
            this.cameraManager.openCamera(this.cameraId, this.cameraDeviceCallback, null);
        }
        catch (CameraAccessException e) {
            this.callbackHandler.onError(new Error(1, "Failed to open camera: " + this.cameraId, e));
        }
    }

    @Override
    public void restartPreview() {
        if (this.isPreviewStarted) {
            this.stopPreview();
            this.startPreview();
        }
    }

    @Override
    public void stopPreview() {
        this.isPreviewStarted = false;
        if (this.orientationEventListener != null) {
            this.orientationEventListener.disable();
        }
        this.throwIfNotInitialized();
        this.closeCamera();
        this.stopBackgroundThread();
    }

    @Override
    public Size getPreviewSize() {
        return this.previewSize;
    }

    @Override
    public Size getImageSize() {
        return this.imageSize;
    }

    @Override
    public void setImageSize(Size size) {
        if (size == null || !this.supportedImageSizes.contains(size)) {
            this.callbackHandler.onError(new Error(5, size + " not supported."));
            return;
        }
        if (this.imageSize.equals(size)) {
            return;
        }
        this.resetSizes();
        this.imageSize = size;
        this.restartPreview();
    }

    @Override
    public Size getVideoSize() {
        return this.videoSize;
    }

    @Override
    public void setVideoSize(Size size) {
        if (size == null || !this.supportedVideoSizes.contains(size)) {
            this.callbackHandler.onError(new Error(5, size + " not supported."));
            return;
        }
        if (this.videoSize.equals(size)) {
            return;
        }
        this.resetSizes();
        this.videoSize = size;
        this.restartPreview();
    }

    @Override
    public Set<AspectRatio> getSupportedAspectRatios() {
        return this.previewSizeMap.ratios();
    }

    @Override
    public void setAspectRatio(AspectRatio ratio) {
        if (!this.isPreviewStarted) {
            this.aspectRatio = ratio;
            return;
        }
        if (ratio == null || !this.previewSizeMap.ratios().contains(ratio)) {
            this.callbackHandler.onError(new Error(5, ratio + " not supported."));
            return;
        }
        if (ratio.equals(this.aspectRatio)) {
            return;
        }
        this.resetSizes();
        this.aspectRatio = ratio;
        this.restartPreview();
    }

    @Override
    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    public void setAutoFocus(boolean autoFocus) {
        if (this.autoFocus == autoFocus) {
            return;
        }
        this.autoFocus = autoFocus;
        if (this.previewRequestBuilder != null) {
            this.updateAutoFocus();
            this.updatePreview(() -> {
                this.autoFocus = !this.autoFocus;
            });
        }
    }

    @Override
    public boolean getAutoFocus() {
        return this.autoFocus;
    }

    @Override
    public void setFacing(int facing) {
        this.facing = facing;
        this.restartPreview();
    }

    @Override
    public int getFacing() {
        return this.facing;
    }

    @Override
    public void setFlash(int flash) {
        if (this.flash == flash) {
            return;
        }
        int saved = this.flash;
        this.flash = flash;
        if (this.previewRequestBuilder != null) {
            this.updateFlash();
            this.updatePreview(() -> {
                this.flash = saved;
            });
        }
    }

    @Override
    public int getFlash() {
        return this.flash;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.restartPreview();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    private void collectPreviewSizes(StreamConfigurationMap map) {
        this.supportedPreviewSizes.clear();
        for (android.util.Size size : map.getOutputSizes(SurfaceTexture.class)) {
            Size s = new Size(size.getWidth(), size.getHeight());
            this.supportedPreviewSizes.add(s);
            this.previewSizeMap.add(s);
        }
    }

    private void collectImageSizes(StreamConfigurationMap map) {
        this.supportedImageSizes.clear();
        for (android.util.Size size : map.getOutputSizes(256)) {
            Size s = new Size(size.getWidth(), size.getHeight());
            this.supportedImageSizes.add(s);
            this.imageSizeMap.add(s);
        }
    }

    private void collectVideoSizes(StreamConfigurationMap map) {
        this.supportedVideoSizes.clear();
        for (android.util.Size size : map.getOutputSizes(MediaRecorder.class)) {
            if (size.getHeight() > 1080) continue;
            Size s = new Size(size.getWidth(), size.getHeight());
            this.supportedVideoSizes.add(s);
            this.videoSizeMap.add(s);
        }
    }

    private void refineSizes() {
        for (AspectRatio ratio : this.previewSizeMap.ratios()) {
            if ((this.mode != 1 || this.videoSizeMap.ratios().contains(ratio)) && (this.mode != 0 || this.imageSizeMap.ratios().contains(ratio))) continue;
            if (this.previewSizeMap.sizes(ratio) != null) {
                this.supportedPreviewSizes.removeAll(this.previewSizeMap.sizes(ratio));
            }
            this.previewSizeMap.remove(ratio);
        }
        if (this.aspectRatio != null && !this.previewSizeMap.ratios().contains(this.aspectRatio)) {
            this.aspectRatio = this.previewSizeMap.ratios().iterator().next();
        }
    }

    private static Size chooseVideoSize(SortedSet<Size> choices) {
        Size chosen = null;
        for (Size size : choices) {
            if (size.getWidth() != size.getHeight() * 4 / 3 || size.getHeight() > 1080) continue;
            chosen = size;
        }
        if (chosen != null) {
            return chosen;
        }
        return choices.last();
    }

    private Size chooseOptimalPreviewSize(Size preferred) {
        int surfaceShorter;
        int surfaceLonger;
        int surfaceHeight;
        int surfaceWidth = preferred.getWidth();
        if (surfaceWidth < (surfaceHeight = preferred.getHeight())) {
            surfaceLonger = surfaceHeight;
            surfaceShorter = surfaceWidth;
        } else {
            surfaceLonger = surfaceWidth;
            surfaceShorter = surfaceHeight;
        }
        AspectRatio preferredAspectRatio = AspectRatio.of(surfaceLonger, surfaceShorter);
        for (Size size : this.supportedPreviewSizes) {
            if (!preferredAspectRatio.matches(size) || size.getWidth() < surfaceLonger || size.getHeight() < surfaceShorter) continue;
            return size;
        }
        SortedSet<Size> matchedSizes = this.previewSizeMap.sizes(preferredAspectRatio);
        if (matchedSizes != null && matchedSizes.size() > 0) {
            return matchedSizes.last();
        }
        return this.supportedPreviewSizes.last();
    }

    private void closeCamera() {
        this.closePreviewSession();
        if (this.camera != null) {
            this.camera.close();
            this.camera = null;
        }
        if (this.mediaRecorder != null) {
            this.mediaRecorder.release();
            this.mediaRecorder = null;
        }
    }

    private void closePreviewSession() {
        if (this.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
    }

    private void startCaptureSession() {
        if (this.camera == null || this.textureView.getSurfaceTexture() == null || this.mode == 0 && this.imageReader == null) {
            return;
        }
        try {
            this.textureView.setBufferSize(this.previewSize.getWidth(), this.previewSize.getHeight());
            this.previewRequestBuilder = this.camera.createCaptureRequest(1);
            Surface previewSurface = this.textureView.getSurface();
            this.previewRequestBuilder.addTarget(previewSurface);
            ArrayList<Surface> surfaces = new ArrayList<Surface>();
            surfaces.add(previewSurface);
            if (this.mode == 0) {
                surfaces.add(this.imageReader.getSurface());
            }
            this.camera.createCaptureSession(surfaces, this.sessionCallback, null);
            this.setupTapToFocus();
        }
        catch (CameraAccessException e) {
            this.callbackHandler.onError(new Error(1, (Throwable)e));
        }
    }

    private void updateAutoFocus() {
        if (!this.autoFocus) {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            return;
        }
        int[] modes = (int[])this.characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        if (modes == null || modes.length == 0 || modes.length == 1 && modes[0] == 0) {
            this.autoFocus = false;
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
        } else if (this.mode == 0) {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
        } else {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
        }
    }

    private void updateFlash() {
        switch (this.flash) {
            case 0: {
                this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                this.previewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 1: {
                this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                this.previewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 2: {
                this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                this.previewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                break;
            }
            case 3: {
                this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                this.previewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            case 4: {
                this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)4);
                this.previewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
        }
    }

    @Override
    public void takePicture() {
        try {
            this.nextImageAbsolutePath = Utils.getImageFilePath();
        }
        catch (IOException e) {
            this.callbackHandler.onError(Utils.errorFromThrowable(e));
            return;
        }
        if (this.autoFocus) {
            this.lockFocus();
        } else {
            this.captureStillPicture();
        }
        this.preview.shot();
    }

    @Override
    public void startRecording(Photographer.MediaRecorderConfigurator configurator) {
        this.throwIfNoMediaRecorder();
        if (this.camera == null || !this.textureView.isAvailable() || this.previewSize == null) {
            this.callbackHandler.onError(new Error(1));
            return;
        }
        try {
            this.nextVideoAbsolutePath = Utils.getVideoFilePath();
        }
        catch (IOException e) {
            this.callbackHandler.onError(Utils.errorFromThrowable(e));
            return;
        }
        try {
            this.closePreviewSession();
            this.setUpMediaRecorder(configurator);
            this.previewRequestBuilder = this.camera.createCaptureRequest(3);
            ArrayList<Surface> surfaces = new ArrayList<Surface>();
            Surface previewSurface = this.textureView.getSurface();
            surfaces.add(previewSurface);
            this.previewRequestBuilder.addTarget(previewSurface);
            Surface recorderSurface = this.mediaRecorder.getSurface();
            surfaces.add(recorderSurface);
            this.previewRequestBuilder.addTarget(recorderSurface);
            this.camera.createCaptureSession(surfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Camera2Photographer.this.captureSession = cameraCaptureSession;
                    Camera2Photographer.this.updatePreview(null);
                    Camera2Photographer.this.isRecordingVideo = true;
                    Camera2Photographer.this.mediaRecorder.start();
                    Camera2Photographer.this.callbackHandler.onStartRecording();
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Camera2Photographer.this.callbackHandler.onError(new Error(1));
                }
            }, null);
        }
        catch (CameraAccessException e) {
            this.callbackHandler.onError(new Error(1, (Throwable)e));
        }
        catch (IOException e) {
            this.callbackHandler.onError(Utils.errorFromThrowable(e));
        }
    }

    private void setUpMediaRecorder(Photographer.MediaRecorderConfigurator configurator) throws IOException {
        if (configurator == null || configurator.useDefaultConfigs()) {
            this.mediaRecorder.setAudioSource(1);
            this.mediaRecorder.setVideoSource(2);
            this.mediaRecorder.setOutputFormat(2);
            this.mediaRecorder.setOutputFile(this.nextVideoAbsolutePath);
            this.mediaRecorder.setVideoEncodingBitRate(10000000);
            this.mediaRecorder.setVideoFrameRate(30);
            this.mediaRecorder.setVideoSize(this.videoSize.getWidth(), this.videoSize.getHeight());
            this.mediaRecorder.setVideoEncoder(2);
            this.mediaRecorder.setAudioEncoder(3);
        }
        if (configurator != null) {
            configurator.configure(this.mediaRecorder);
        }
        this.mediaRecorder.setOrientationHint(this.getDeviceOrientation());
        this.mediaRecorder.prepare();
    }

    @Override
    public void pauseRecording() {
        this.throwIfNoMediaRecorder();
        if (!this.isRecordingVideo) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.mediaRecorder.pause();
        } else {
            this.callbackHandler.onError(new Error(2));
        }
    }

    @Override
    public void resumeRecording() {
        this.throwIfNoMediaRecorder();
        if (!this.isRecordingVideo) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            this.mediaRecorder.resume();
        } else {
            this.callbackHandler.onError(new Error(2));
        }
    }

    @Override
    public void finishRecording() {
        if (!this.isRecordingVideo) {
            return;
        }
        this.throwIfNoMediaRecorder();
        this.isRecordingVideo = false;
        this.mediaRecorder.stop();
        this.mediaRecorder.reset();
        this.callbackHandler.onFinishRecording(this.nextVideoAbsolutePath);
        this.startCaptureSession();
    }

    @Override
    public void setOnEventListener(Photographer.OnEventListener listener) {
        this.throwIfNotInitialized();
        this.callbackHandler.setOnEventListener(listener);
    }

    private void lockFocus() {
        this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        try {
            this.imageCaptureCallback.setState(1);
            this.captureSession.capture(this.previewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.imageCaptureCallback, null);
        }
        catch (CameraAccessException e) {
            this.callbackHandler.onError(new Error(1, "Failed to lock focus.", e));
        }
    }

    private void captureStillPicture() {
        try {
            CaptureRequest.Builder captureRequestBuilder = this.camera.createCaptureRequest(2);
            captureRequestBuilder.addTarget(this.imageReader.getSurface());
            captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, this.previewRequestBuilder.get(CaptureRequest.CONTROL_AF_MODE));
            switch (this.flash) {
                case 0: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                    break;
                }
                case 1: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)3);
                    break;
                }
                case 2: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                    break;
                }
                case 3: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                    break;
                }
                case 4: {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                }
            }
            captureRequestBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)this.getDeviceOrientation());
            this.captureSession.stopRepeating();
            this.captureSession.capture(captureRequestBuilder.build(), new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                    Camera2Photographer.this.unlockFocus();
                    Camera2Photographer.this.callbackHandler.onShotFinished(Camera2Photographer.this.nextImageAbsolutePath);
                }

                public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
                    Camera2Photographer.this.unlockFocus();
                    Camera2Photographer.this.callbackHandler.onError(new Error(1));
                }
            }, null);
        }
        catch (CameraAccessException e) {
            this.callbackHandler.onError(new Error(1, "Cannot capture a still picture.", e));
        }
    }

    private void unlockFocus() {
        this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        try {
            this.captureSession.capture(this.previewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.imageCaptureCallback, null);
            this.updateAutoFocus();
            this.updateFlash();
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            this.captureSession.setRepeatingRequest(this.previewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.imageCaptureCallback, null);
            this.imageCaptureCallback.setState(0);
        }
        catch (CameraAccessException e) {
            this.callbackHandler.onError(new Error(1, (Throwable)e));
        }
    }

    private int getDisplayOrientation() {
        int rotation = this.activityContext.getWindowManager().getDefaultDisplay().getRotation();
        return this.getOrientation(rotation);
    }

    private int getDeviceOrientation() {
        return this.getOrientation(this.currentDeviceRotation);
    }

    private int getOrientation(int rotation) {
        int degree = DEFAULT_ORIENTATIONS.get(rotation);
        switch (this.sensorOrientation) {
            case 90: {
                degree = DEFAULT_ORIENTATIONS.get(rotation);
                break;
            }
            case 270: {
                degree = INVERSE_ORIENTATIONS.get(rotation);
            }
        }
        return degree;
    }

    private void startBackgroundThread() {
        this.backgroundThread = new HandlerThread("CameraBackground");
        this.backgroundThread.start();
        this.backgroundHandler = new Handler(this.backgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        this.backgroundThread.quitSafely();
        try {
            this.backgroundThread.join();
            this.backgroundThread = null;
            this.backgroundHandler = null;
        }
        catch (InterruptedException e) {
            this.callbackHandler.onError(new Error(-1, (Throwable)e));
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setupTapToFocus() {
        this.textureView.setOnTouchListener((v, event) -> {
            int focusY;
            int focusX;
            int actionMasked = event.getActionMasked();
            if (actionMasked != 0) {
                return false;
            }
            if (this.isManualFocusEngaged) {
                return true;
            }
            Rect sensorArraySize = (Rect)this.characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
            if (sensorArraySize == null) {
                return false;
            }
            int eventX = (int)event.getX();
            int eventY = (int)event.getY();
            int degree = this.getDisplayOrientation();
            switch (degree) {
                case 0: {
                    focusX = (int)((float)eventX / (float)v.getWidth() * (float)sensorArraySize.width());
                    focusY = (int)((float)eventY / (float)v.getHeight() * (float)sensorArraySize.height());
                    break;
                }
                case 180: {
                    focusX = (int)((1.0f - (float)eventX / (float)v.getWidth()) * (float)sensorArraySize.width());
                    focusY = (int)((1.0f - (float)eventY / (float)v.getHeight()) * (float)sensorArraySize.height());
                    break;
                }
                case 270: {
                    focusX = (int)((1.0f - (float)eventY / (float)v.getHeight()) * (float)sensorArraySize.width());
                    focusY = (int)((float)eventX / (float)v.getWidth() * (float)sensorArraySize.height());
                    break;
                }
                default: {
                    focusX = (int)((float)eventY / (float)v.getHeight() * (float)sensorArraySize.width());
                    focusY = (int)((1.0f - (float)eventX / (float)v.getWidth()) * (float)sensorArraySize.height());
                }
            }
            MeteringRectangle focusAreaTouch = new MeteringRectangle(Math.max(focusX - 150, 0), Math.max(focusY - 150, 0), 300, 300, 999);
            CameraCaptureSession.CaptureCallback focusCallbackHandler = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                    Camera2Photographer.this.isManualFocusEngaged = false;
                    if (request.getTag() == "FOCUS_TAG") {
                        Camera2Photographer.this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, null);
                        Camera2Photographer.this.updatePreview(null);
                        Camera2Photographer.this.preview.focusFinished();
                    }
                }

                public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
                    Camera2Photographer.this.isManualFocusEngaged = false;
                    Camera2Photographer.this.preview.focusFinished();
                }
            };
            try {
                this.captureSession.stopRepeating();
            }
            catch (CameraAccessException e) {
                this.callbackHandler.onError(new Error(1, (Throwable)e));
                return true;
            }
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            Integer maxRegionsAf = (Integer)this.characteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
            if (maxRegionsAf != null && maxRegionsAf >= 1) {
                this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{focusAreaTouch});
            }
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.previewRequestBuilder.setTag((Object)"FOCUS_TAG");
            try {
                this.captureSession.capture(this.previewRequestBuilder.build(), focusCallbackHandler, null);
                this.preview.focusRequestAt(eventX, eventY);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
                this.callbackHandler.onError(new Error(1, (Throwable)e));
                return true;
            }
            this.isManualFocusEngaged = true;
            return true;
        });
    }

    private void updatePreview(Runnable exceptionCallback) {
        if (this.camera == null) {
            return;
        }
        try {
            if (this.mode == 0) {
                this.captureSession.setRepeatingRequest(this.previewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.imageCaptureCallback, null);
            } else {
                this.previewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
                this.captureSession.setRepeatingRequest(this.previewRequestBuilder.build(), null, null);
            }
        }
        catch (CameraAccessException e) {
            if (exceptionCallback != null) {
                exceptionCallback.run();
            }
            this.callbackHandler.onError(new Error(1, (Throwable)e));
        }
    }

    static {
        INTERNAL_FACINGS.put(0, 1);
        INTERNAL_FACINGS.put(1, 0);
        DEFAULT_ORIENTATIONS = new SparseIntArray();
        INVERSE_ORIENTATIONS = new SparseIntArray();
        DEFAULT_ORIENTATIONS.append(0, 90);
        DEFAULT_ORIENTATIONS.append(1, 0);
        DEFAULT_ORIENTATIONS.append(2, 270);
        DEFAULT_ORIENTATIONS.append(3, 180);
        INVERSE_ORIENTATIONS.append(0, 270);
        INVERSE_ORIENTATIONS.append(1, 180);
        INVERSE_ORIENTATIONS.append(2, 90);
        INVERSE_ORIENTATIONS.append(3, 0);
        RECORD_VIDEO_PERMISSIONS = new ArrayList(3);
        RECORD_VIDEO_PERMISSIONS.add("android.permission.CAMERA");
        RECORD_VIDEO_PERMISSIONS.add("android.permission.RECORD_AUDIO");
        RECORD_VIDEO_PERMISSIONS.add("android.permission.WRITE_EXTERNAL_STORAGE");
    }

    private static class CallbackHandler
    extends Handler {
        private Photographer.OnEventListener onEventListener;

        CallbackHandler(Context context) {
            super(context.getMainLooper());
        }

        void setOnEventListener(Photographer.OnEventListener listener) {
            this.onEventListener = listener;
        }

        public void handleMessage(Message msg) {
            if (this.onEventListener == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    this.onEventListener.onDeviceConfigured();
                    break;
                }
                case 2: {
                    this.onEventListener.onPreviewStarted();
                    break;
                }
                case 3: {
                    this.onEventListener.onPreviewStopped();
                    break;
                }
                case 4: {
                    this.onEventListener.onStartRecording();
                    break;
                }
                case 5: {
                    this.onEventListener.onFinishRecording((String)msg.obj);
                    break;
                }
                case 6: {
                    this.onEventListener.onShotFinished((String)msg.obj);
                    break;
                }
                case 7: {
                    this.onEventListener.onError((Error)msg.obj);
                    break;
                }
            }
        }

        void onDeviceConfigured() {
            Message.obtain((Handler)this, (int)1).sendToTarget();
        }

        void onPreviewStarted() {
            Message.obtain((Handler)this, (int)2).sendToTarget();
        }

        void onPreviewStopped() {
            Message.obtain((Handler)this, (int)3).sendToTarget();
        }

        void onStartRecording() {
            Message.obtain((Handler)this, (int)4).sendToTarget();
        }

        void onFinishRecording(String filePath) {
            Message.obtain((Handler)this, (int)5, (Object)filePath).sendToTarget();
        }

        void onShotFinished(String filePath) {
            Message.obtain((Handler)this, (int)6, (Object)filePath).sendToTarget();
        }

        void onError(Error error) {
            Message.obtain((Handler)this, (int)7, (Object)error).sendToTarget();
        }
    }
}

