/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import java.util.LinkedList;
import java.util.List;

class AutoFitTextureView
extends TextureView {
    private int ratioWidth = 0;
    private int ratioHeight = 0;
    private boolean fillSpace = false;
    private int displayOrientation;
    private List<Callback> callbacks = new LinkedList<Callback>();

    public AutoFitTextureView(Context context) {
        this(context, null);
    }

    public AutoFitTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AutoFitTextureView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                AutoFitTextureView.this.configureTransform();
                AutoFitTextureView.this.dispatchSurfaceChanged();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                AutoFitTextureView.this.configureTransform();
                AutoFitTextureView.this.dispatchSurfaceChanged();
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
    }

    public void setAspectRatio(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Size cannot be negative.");
        }
        this.ratioWidth = width;
        this.ratioHeight = height;
        this.requestLayout();
    }

    public boolean isFillSpace() {
        return this.fillSpace;
    }

    public void setFillSpace(boolean fillSpace) {
        this.fillSpace = fillSpace;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (0 == this.ratioWidth || 0 == this.ratioHeight) {
            this.setMeasuredDimension(width, height);
        } else {
            boolean isFillSpaceWithoutScale;
            boolean bl = isFillSpaceWithoutScale = width == height * this.ratioWidth / this.ratioHeight;
            if (isFillSpaceWithoutScale) {
                this.setMeasuredDimension(width, height);
                return;
            }
            if (this.fillSpace) {
                if (width < height * this.ratioWidth / this.ratioHeight) {
                    this.setMeasuredDimension(height * this.ratioWidth / this.ratioHeight, height);
                } else {
                    this.setMeasuredDimension(width, width * this.ratioHeight / this.ratioWidth);
                }
            } else if (width < height * this.ratioWidth / this.ratioHeight) {
                this.setMeasuredDimension(width, width * this.ratioHeight / this.ratioWidth);
            } else {
                this.setMeasuredDimension(height * this.ratioWidth / this.ratioHeight, height);
            }
        }
    }

    Surface getSurface() {
        return new Surface(this.getSurfaceTexture());
    }

    void setBufferSize(int width, int height) {
        this.getSurfaceTexture().setDefaultBufferSize(width, height);
    }

    int getDisplayOrientation() {
        return this.displayOrientation;
    }

    void setDisplayOrientation(int displayOrientation) {
        this.displayOrientation = displayOrientation;
        this.configureTransform();
    }

    private void configureTransform() {
        Matrix matrix = new Matrix();
        if (this.displayOrientation % 180 == 90) {
            float[] fArray;
            int width = this.getWidth();
            int height = this.getHeight();
            float[] fArray2 = new float[]{0.0f, 0.0f, width, 0.0f, 0.0f, height, width, height};
            if (this.displayOrientation == 90) {
                float[] fArray3 = new float[8];
                fArray3[0] = 0.0f;
                fArray3[1] = height;
                fArray3[2] = 0.0f;
                fArray3[3] = 0.0f;
                fArray3[4] = width;
                fArray3[5] = height;
                fArray3[6] = width;
                fArray = fArray3;
                fArray3[7] = 0.0f;
            } else {
                float[] fArray4 = new float[8];
                fArray4[0] = width;
                fArray4[1] = 0.0f;
                fArray4[2] = width;
                fArray4[3] = height;
                fArray4[4] = 0.0f;
                fArray4[5] = 0.0f;
                fArray4[6] = 0.0f;
                fArray = fArray4;
                fArray4[7] = height;
            }
            matrix.setPolyToPoly(fArray2, 0, fArray, 0, 4);
        } else if (this.displayOrientation == 180) {
            matrix.postRotate(180.0f, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        }
        this.setTransform(matrix);
    }

    public void addCallback(Callback callback) {
        if (callback != null) {
            this.callbacks.add(callback);
        }
    }

    protected void dispatchSurfaceChanged() {
        for (Callback callback : this.callbacks) {
            callback.onSurfaceChanged();
        }
    }

    static interface Callback {
        public void onSurfaceChanged();
    }
}

