/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.content.Context;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.OrientationEventListener;

abstract class DisplayOrientationDetector {
    private final OrientationEventListener mOrientationEventListener;
    private static final SparseIntArray DISPLAY_ORIENTATIONS = new SparseIntArray();
    private Display mDisplay;
    private int mLastKnownDisplayOrientation = 0;

    public DisplayOrientationDetector(Context context) {
        this.mOrientationEventListener = new OrientationEventListener(context){
            private int mLastKnownRotation;
            {
                this.mLastKnownRotation = -1;
            }

            public void onOrientationChanged(int orientation) {
                if (orientation == -1 || DisplayOrientationDetector.this.mDisplay == null) {
                    return;
                }
                int rotation = DisplayOrientationDetector.this.mDisplay.getRotation();
                if (this.mLastKnownRotation != rotation) {
                    this.mLastKnownRotation = rotation;
                    DisplayOrientationDetector.this.dispatchOnDisplayOrientationChanged(DISPLAY_ORIENTATIONS.get(rotation));
                }
            }
        };
    }

    public void enable(Display display) {
        this.mDisplay = display;
        this.mOrientationEventListener.enable();
        this.dispatchOnDisplayOrientationChanged(DISPLAY_ORIENTATIONS.get(display.getRotation()));
    }

    public void disable() {
        this.mOrientationEventListener.disable();
        this.mDisplay = null;
    }

    public int getLastKnownDisplayOrientation() {
        return this.mLastKnownDisplayOrientation;
    }

    private void dispatchOnDisplayOrientationChanged(int displayOrientation) {
        this.mLastKnownDisplayOrientation = displayOrientation;
        this.onDisplayOrientationChanged(displayOrientation);
    }

    abstract void onDisplayOrientationChanged(int var1);

    static {
        DISPLAY_ORIENTATIONS.put(0, 0);
        DISPLAY_ORIENTATIONS.put(1, 90);
        DISPLAY_ORIENTATIONS.put(2, 180);
        DISPLAY_ORIENTATIONS.put(3, 270);
    }
}

