/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.camera;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import top.defaults.camera.AspectRatio;
import top.defaults.camera.AutoFitTextureView;
import top.defaults.camera.CameraViewOverlay;
import top.defaults.camera.CanvasDrawer;
import top.defaults.camera.DisplayOrientationDetector;
import top.defaults.camera.InternalPhotographer;
import top.defaults.camera.R;

public class CameraView
extends RelativeLayout {
    private Context context;
    private AutoFitTextureView textureView;
    private CameraViewOverlay overlay;
    private final DisplayOrientationDetector displayOrientationDetector;
    String aspectRatio;
    boolean autoFocus;
    int facing;
    int flash;
    int mode;

    public CameraView(@NonNull Context context) {
        this(context, null);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.textureView = new AutoFitTextureView(context);
        this.textureView.setId(R.id.textureView);
        RelativeLayout.LayoutParams textureViewParams = new RelativeLayout.LayoutParams(-2, -2);
        textureViewParams.addRule(13);
        this.addView((View)this.textureView, (ViewGroup.LayoutParams)textureViewParams);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CameraView);
        this.aspectRatio = typedArray.getString(R.styleable.CameraView_aspectRatio);
        this.autoFocus = typedArray.getBoolean(R.styleable.CameraView_autoFocus, true);
        this.facing = typedArray.getInt(R.styleable.CameraView_facing, 0);
        this.flash = typedArray.getInt(R.styleable.CameraView_flash, 0);
        this.mode = typedArray.getInt(R.styleable.CameraView_mode, 0);
        boolean fillSpace = typedArray.getBoolean(R.styleable.CameraView_fillSpace, false);
        this.textureView.setFillSpace(fillSpace);
        boolean showFocusIndicator = typedArray.getBoolean(R.styleable.CameraView_showFocusIndicator, true);
        typedArray.recycle();
        this.addOverlay();
        if (showFocusIndicator) {
            this.setFocusIndicatorDrawer(new CanvasDrawer.DefaultCanvasDrawer());
        }
        this.displayOrientationDetector = new DisplayOrientationDetector(context){

            @Override
            public void onDisplayOrientationChanged(int displayOrientation) {
                CameraView.this.textureView.setDisplayOrientation(displayOrientation);
            }
        };
    }

    void assign(InternalPhotographer photographer) {
        photographer.setMode(this.mode);
        photographer.setAspectRatio(AspectRatio.parse(this.aspectRatio));
        photographer.setAutoFocus(this.autoFocus);
        photographer.setFacing(this.facing);
        photographer.setFlash(this.flash);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.displayOrientationDetector.enable(ViewCompat.getDisplay((View)this));
        }
    }

    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.displayOrientationDetector.disable();
        }
        super.onDetachedFromWindow();
    }

    AutoFitTextureView getTextureView() {
        return this.textureView;
    }

    public boolean isFillSpace() {
        return this.textureView.isFillSpace();
    }

    public void setFillSpace(boolean fillSpace) {
        this.textureView.setFillSpace(fillSpace);
    }

    private void addOverlay() {
        this.overlay = new CameraViewOverlay(this.context);
        RelativeLayout.LayoutParams overlayParams = new RelativeLayout.LayoutParams(-2, -2);
        overlayParams.addRule(5, R.id.textureView);
        overlayParams.addRule(6, R.id.textureView);
        overlayParams.addRule(7, R.id.textureView);
        overlayParams.addRule(8, R.id.textureView);
        this.addView((View)this.overlay, (ViewGroup.LayoutParams)overlayParams);
    }

    public void setFocusIndicatorDrawer(CanvasDrawer drawer) {
        this.overlay.setCanvasDrawer(drawer);
    }

    void focusRequestAt(int x, int y) {
        this.overlay.focusRequestAt(x, y);
    }

    void focusFinished() {
        this.overlay.focusFinished();
    }

    void shot() {
        this.overlay.shot();
    }

    public void addCallback(Callback callback) {
        this.textureView.addCallback(callback);
    }

    public static interface Callback
    extends AutoFitTextureView.Callback {
    }
}

