/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.vk.api.sdk.client.ClientResponse;
import com.vk.api.sdk.client.TransportClient;
import com.vk.api.sdk.exceptions.ApiException;
import com.vk.api.sdk.exceptions.ClientException;
import com.vk.api.sdk.exceptions.ExceptionMapper;
import com.vk.api.sdk.objects.base.Error;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiRequest<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ApiRequest.class);
    private TransportClient client;
    private Gson gson;
    private String url;
    private Type responseClass;

    public ApiRequest(String url, TransportClient client, Gson gson, Type responseClass) {
        this.client = client;
        this.url = url;
        this.responseClass = responseClass;
        this.gson = gson;
    }

    protected String getUrl() {
        return this.url;
    }

    protected Gson getGson() {
        return this.gson;
    }

    protected TransportClient getClient() {
        return this.client;
    }

    protected Type getResponseClass() {
        return this.responseClass;
    }

    public boolean isCached() {
        return this.getClient().isCached();
    }

    public boolean isTest() {
        return this.getClient().isTest();
    }

    public T execute() throws ApiException, ClientException {
        String textResponse = this.executeAsString();
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(textResponse));
        JsonObject json = (JsonObject)new JsonParser().parse(jsonReader);
        if (json.has("error")) {
            Error error;
            JsonElement errorElement = json.get("error");
            try {
                error = (Error)this.gson.fromJson(errorElement, Error.class);
            }
            catch (JsonSyntaxException e) {
                LOG.error("Invalid JSON: " + textResponse, (Throwable)e);
                throw new ClientException("Can't parse json response");
            }
            ApiException exception = ExceptionMapper.parseException(error);
            LOG.error("API error", (Throwable)exception);
            throw exception;
        }
        JsonObject response = json;
        if (json.has("response")) {
            response = json.get("response");
        }
        try {
            return (T)this.gson.fromJson((JsonElement)response, this.responseClass);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Invalid JSON: " + textResponse, (Throwable)e);
            throw new ClientException("Can't parse json response");
        }
    }

    public String executeAsString() throws ClientException {
        ClientResponse response;
        try {
            response = this.client.post(this.url, this.getBody());
        }
        catch (IOException e) {
            LOG.error("Problems with request: " + this.url, (Throwable)e);
            throw new ClientException("I/O exception");
        }
        if (response.getStatusCode() != 200) {
            throw new ClientException("Internal API server error. Wrong status code: " + response.getStatusCode() + ". Content: " + response.getContent());
        }
        if (!response.getHeaders().containsKey("Content-Type")) {
            throw new ClientException("No content type header");
        }
        if (!response.getHeaders().get("Content-Type").contains("application/json")) {
            throw new ClientException("Invalid content type");
        }
        return response.getContent();
    }

    protected abstract String getBody();
}

